/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.treasuredata.client.model.TDSavedQueryStartRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TDSavedQueryStartRequest", generator="Immutables")
@Immutable
final class ImmutableTDSavedQueryStartRequest
extends TDSavedQueryStartRequest {
    private final String name;
    @Nullable
    private final Long id;
    private final Date scheduledTime;
    @Nullable
    private final Integer num;
    @Nullable
    private final String domainKey;

    private ImmutableTDSavedQueryStartRequest(String name, @Nullable Long id, Date scheduledTime, @Nullable Integer num, @Nullable String domainKey) {
        this.name = name;
        this.id = id;
        this.scheduledTime = scheduledTime;
        this.num = num;
        this.domainKey = domainKey;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="id")
    public Optional<Long> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="scheduledTime")
    public Date scheduledTime() {
        return this.scheduledTime;
    }

    @Override
    @JsonProperty(value="num")
    public Optional<Integer> num() {
        return Optional.ofNullable(this.num);
    }

    @Override
    @JsonProperty(value="domainKey")
    public Optional<String> domainKey() {
        return Optional.ofNullable(this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(newValue, this.id, this.scheduledTime, this.num, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withId(long value) {
        Long newValue = value;
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, newValue, this.scheduledTime, this.num, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withId(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, value, this.scheduledTime, this.num, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withScheduledTime(Date value) {
        if (this.scheduledTime == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "scheduledTime");
        return new ImmutableTDSavedQueryStartRequest(this.name, this.id, newValue, this.num, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withNum(int value) {
        Integer newValue = value;
        if (Objects.equals(this.num, newValue)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, this.id, this.scheduledTime, newValue, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withNum(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.num, value)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, this.id, this.scheduledTime, value, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequest withDomainKey(String value) {
        String newValue = Objects.requireNonNull(value, "domainKey");
        if (Objects.equals(this.domainKey, newValue)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, this.id, this.scheduledTime, this.num, newValue);
    }

    public final ImmutableTDSavedQueryStartRequest withDomainKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.domainKey, value)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequest(this.name, this.id, this.scheduledTime, this.num, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTDSavedQueryStartRequest && this.equalTo(0, (ImmutableTDSavedQueryStartRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableTDSavedQueryStartRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.id, another.id) && this.scheduledTime.equals(another.scheduledTime) && Objects.equals(this.num, another.num) && Objects.equals(this.domainKey, another.domainKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.scheduledTime.hashCode();
        h += (h << 5) + Objects.hashCode(this.num);
        h += (h << 5) + Objects.hashCode(this.domainKey);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TDSavedQueryStartRequest").omitNullValues().add("name", (Object)this.name).add("id", (Object)this.id).add("scheduledTime", (Object)this.scheduledTime).add("num", (Object)this.num).add("domainKey", (Object)this.domainKey).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTDSavedQueryStartRequest fromJson(Json json) {
        Builder builder = ImmutableTDSavedQueryStartRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.scheduledTime != null) {
            builder.scheduledTime(json.scheduledTime);
        }
        if (json.num != null) {
            builder.num((Optional)json.num);
        }
        if (json.domainKey != null) {
            builder.domainKey((Optional)json.domainKey);
        }
        return builder.build();
    }

    public static ImmutableTDSavedQueryStartRequest copyOf(TDSavedQueryStartRequest instance) {
        if (instance instanceof ImmutableTDSavedQueryStartRequest) {
            return (ImmutableTDSavedQueryStartRequest)instance;
        }
        return ImmutableTDSavedQueryStartRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TDSavedQueryStartRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements TDSavedQueryStartRequest.Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SCHEDULED_TIME = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private Long id;
        @Nullable
        private Date scheduledTime;
        @Nullable
        private Integer num;
        @Nullable
        private String domainKey;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TDSavedQueryStartRequest instance) {
            Optional<String> domainKeyOptional;
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            Optional<Long> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            this.scheduledTime(instance.scheduledTime());
            Optional<Integer> numOptional = instance.num();
            if (numOptional.isPresent()) {
                this.num((Optional)numOptional);
            }
            if ((domainKeyOptional = instance.domainKey()).isPresent()) {
                this.domainKey((Optional)domainKeyOptional);
            }
            return this;
        }

        @Override
        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(Optional<Long> id) {
            this.id = id.orElse(null);
            return this;
        }

        @Override
        @JsonProperty(value="scheduledTime")
        @CanIgnoreReturnValue
        public final Builder scheduledTime(Date scheduledTime) {
            this.scheduledTime = Objects.requireNonNull(scheduledTime, "scheduledTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder num(int num) {
            this.num = num;
            return this;
        }

        @Override
        @JsonProperty(value="num")
        @CanIgnoreReturnValue
        public final Builder num(Optional<Integer> num) {
            this.num = num.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder domainKey(String domainKey) {
            this.domainKey = Objects.requireNonNull(domainKey, "domainKey");
            return this;
        }

        @Override
        @JsonProperty(value="domainKey")
        @CanIgnoreReturnValue
        public final Builder domainKey(Optional<String> domainKey) {
            this.domainKey = domainKey.orElse(null);
            return this;
        }

        @Override
        public ImmutableTDSavedQueryStartRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTDSavedQueryStartRequest(this.name, this.id, this.scheduledTime, this.num, this.domainKey);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scheduledTime");
            }
            return "Cannot build TDSavedQueryStartRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TDSavedQueryStartRequest", generator="Immutables")
    static final class Json
    extends TDSavedQueryStartRequest {
        @Nullable
        String name;
        @Nullable
        Optional<Long> id = Optional.empty();
        @Nullable
        Date scheduledTime;
        @Nullable
        Optional<Integer> num = Optional.empty();
        @Nullable
        Optional<String> domainKey = Optional.empty();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="id")
        public void setId(Optional<Long> id) {
            this.id = id;
        }

        @JsonProperty(value="scheduledTime")
        public void setScheduledTime(Date scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @JsonProperty(value="num")
        public void setNum(Optional<Integer> num) {
            this.num = num;
        }

        @JsonProperty(value="domainKey")
        public void setDomainKey(Optional<String> domainKey) {
            this.domainKey = domainKey;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date scheduledTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> num() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> domainKey() {
            throw new UnsupportedOperationException();
        }
    }
}

