/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.treasuredata.client.model.TDSavedQueryStartRequestV4;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TDSavedQueryStartRequestV4", generator="Immutables")
@Immutable
final class ImmutableTDSavedQueryStartRequestV4
extends TDSavedQueryStartRequestV4 {
    private final String scheduledTime;
    @Nullable
    private final String domainKey;

    private ImmutableTDSavedQueryStartRequestV4(String scheduledTime, @Nullable String domainKey) {
        this.scheduledTime = scheduledTime;
        this.domainKey = domainKey;
    }

    @Override
    @JsonProperty(value="scheduled_time")
    public String scheduledTime() {
        return this.scheduledTime;
    }

    @Override
    @JsonProperty(value="domain_key")
    public Optional<String> domainKey() {
        return Optional.ofNullable(this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequestV4 withScheduledTime(String value) {
        String newValue = Objects.requireNonNull(value, "scheduledTime");
        if (this.scheduledTime.equals(newValue)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequestV4(newValue, this.domainKey);
    }

    public final ImmutableTDSavedQueryStartRequestV4 withDomainKey(String value) {
        String newValue = Objects.requireNonNull(value, "domainKey");
        if (Objects.equals(this.domainKey, newValue)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequestV4(this.scheduledTime, newValue);
    }

    public final ImmutableTDSavedQueryStartRequestV4 withDomainKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.domainKey, value)) {
            return this;
        }
        return new ImmutableTDSavedQueryStartRequestV4(this.scheduledTime, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTDSavedQueryStartRequestV4 && this.equalTo(0, (ImmutableTDSavedQueryStartRequestV4)another);
    }

    private boolean equalTo(int synthetic, ImmutableTDSavedQueryStartRequestV4 another) {
        return this.scheduledTime.equals(another.scheduledTime) && Objects.equals(this.domainKey, another.domainKey);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scheduledTime.hashCode();
        h += (h << 5) + Objects.hashCode(this.domainKey);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TDSavedQueryStartRequestV4").omitNullValues().add("scheduledTime", (Object)this.scheduledTime).add("domainKey", (Object)this.domainKey).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTDSavedQueryStartRequestV4 fromJson(Json json) {
        Builder builder = ImmutableTDSavedQueryStartRequestV4.builder();
        if (json.scheduledTime != null) {
            builder.scheduledTime(json.scheduledTime);
        }
        if (json.domainKey != null) {
            builder.domainKey((Optional)json.domainKey);
        }
        return builder.build();
    }

    public static ImmutableTDSavedQueryStartRequestV4 copyOf(TDSavedQueryStartRequestV4 instance) {
        if (instance instanceof ImmutableTDSavedQueryStartRequestV4) {
            return (ImmutableTDSavedQueryStartRequestV4)instance;
        }
        return ImmutableTDSavedQueryStartRequestV4.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TDSavedQueryStartRequestV4", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements TDSavedQueryStartRequestV4.Builder {
        private static final long INIT_BIT_SCHEDULED_TIME = 1L;
        private long initBits = 1L;
        @Nullable
        private String scheduledTime;
        @Nullable
        private String domainKey;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TDSavedQueryStartRequestV4 instance) {
            Objects.requireNonNull(instance, "instance");
            this.scheduledTime(instance.scheduledTime());
            Optional<String> domainKeyOptional = instance.domainKey();
            if (domainKeyOptional.isPresent()) {
                this.domainKey((Optional)domainKeyOptional);
            }
            return this;
        }

        @Override
        @JsonProperty(value="scheduled_time")
        @CanIgnoreReturnValue
        public final Builder scheduledTime(String scheduledTime) {
            this.scheduledTime = Objects.requireNonNull(scheduledTime, "scheduledTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder domainKey(String domainKey) {
            this.domainKey = Objects.requireNonNull(domainKey, "domainKey");
            return this;
        }

        @Override
        @JsonProperty(value="domain_key")
        @CanIgnoreReturnValue
        public final Builder domainKey(Optional<String> domainKey) {
            this.domainKey = domainKey.orElse(null);
            return this;
        }

        @Override
        public ImmutableTDSavedQueryStartRequestV4 build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTDSavedQueryStartRequestV4(this.scheduledTime, this.domainKey);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("scheduledTime");
            }
            return "Cannot build TDSavedQueryStartRequestV4, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TDSavedQueryStartRequestV4", generator="Immutables")
    static final class Json
    extends TDSavedQueryStartRequestV4 {
        @Nullable
        String scheduledTime;
        @Nullable
        Optional<String> domainKey = Optional.empty();

        Json() {
        }

        @JsonProperty(value="scheduled_time")
        public void setScheduledTime(String scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @JsonProperty(value="domain_key")
        public void setDomainKey(Optional<String> domainKey) {
            this.domainKey = domainKey;
        }

        @Override
        public String scheduledTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> domainKey() {
            throw new UnsupportedOperationException();
        }
    }
}

