/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.treasuredata.client.model.TDColumnType;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public class TDColumn
implements Serializable {
    static final byte[] LOG_TABLE_PUSHDOWN_KEY = "time".getBytes(StandardCharsets.UTF_8);
    private final String name;
    private final TDColumnType type;
    private final byte[] key;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public TDColumn(String name, TDColumnType type) {
        this(name, type, name.getBytes(StandardCharsets.UTF_8));
    }

    @JsonCreator
    public TDColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="key") String key) {
        this(name, TDColumnType.parseColumnType(type), key.getBytes(StandardCharsets.UTF_8));
    }

    public TDColumn(String name, TDColumnType type, byte[] key) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.key = Arrays.copyOf(Objects.requireNonNull(key, "key is null"), key.length);
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public TDColumnType getType() {
        return this.type;
    }

    @JsonIgnore
    public byte[] getKey() {
        return Arrays.copyOf(this.key, this.key.length);
    }

    @JsonProperty(value="key")
    public String getKeyString() {
        return new String(this.key, StandardCharsets.UTF_8);
    }

    public static List<TDColumn> parseTuple(String jsonStr) {
        try {
            String unescaped = jsonStr.replaceAll("\\\"", "\"");
            String[][] arr = (String[][])objectMapper.readValue(unescaped, String[][].class);
            ArrayList<TDColumn> columnList = new ArrayList<TDColumn>(arr.length);
            for (String[] columnNameAndType : arr) {
                columnList.add(TDColumn.parseTuple(columnNameAndType));
            }
            return columnList;
        }
        catch (JsonProcessingException e) {
            LoggerFactory.getLogger(TDColumn.class).error("Failed to parse json string", (Throwable)e);
            return new ArrayList<TDColumn>(0);
        }
    }

    public static TDColumn parseTuple(String[] tuple) {
        if (tuple != null) {
            if (tuple.length == 2) {
                return new TDColumn(tuple[0], TDColumnType.parseColumnType(tuple[1]), tuple[0].getBytes(StandardCharsets.UTF_8));
            }
            if (tuple.length == 3) {
                return new TDColumn(tuple[2], TDColumnType.parseColumnType(tuple[1]), tuple[0].getBytes(StandardCharsets.UTF_8));
            }
        }
        throw new RuntimeJsonMappingException("Unexpected string tuple to deserialize TDColumn");
    }

    @JsonIgnore
    public boolean isPartitionKey() {
        return Arrays.equals(LOG_TABLE_PUSHDOWN_KEY, this.getKey());
    }

    @JsonIgnore
    public String[] getTuple() {
        return new String[]{this.getKeyString(), this.type.toString(), this.name};
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TDColumn other = (TDColumn)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Arrays.equals(this.key, other.key);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, Arrays.hashCode(this.key));
    }

    public String toString() {
        return String.format("%s:%s", this.name, this.type.toString());
    }
}

