/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.treasuredata.client.model.TDTypeName;
import com.treasuredata.client.model.impl.TDColumnTypeDeserializer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(using=TDColumnTypeDeserializer.class)
public class TDColumnType
implements Serializable {
    public static final TDColumnType INT = new TDColumnType(TDTypeName.INT, Collections.emptyList());
    public static final TDColumnType LONG = new TDColumnType(TDTypeName.LONG, Collections.emptyList());
    public static final TDColumnType FLOAT = new TDColumnType(TDTypeName.FLOAT, Collections.emptyList());
    public static final TDColumnType DOUBLE = new TDColumnType(TDTypeName.DOUBLE, Collections.emptyList());
    public static final TDColumnType STRING = new TDColumnType(TDTypeName.STRING, Collections.emptyList());
    public static final List<TDColumnType> primitiveTypes = Arrays.asList(INT, LONG, FLOAT, DOUBLE, STRING);
    private final TDTypeName typeName;
    private final List<TDColumnType> elementTypes;

    public static TDColumnType newArrayType(TDColumnType elementType) {
        return new TDColumnType(TDTypeName.ARRAY, Collections.singletonList(elementType));
    }

    public static TDColumnType newMapType(TDColumnType keyType, TDColumnType valueType) {
        return new TDColumnType(TDTypeName.MAP, Arrays.asList(keyType, valueType));
    }

    private TDColumnType(TDTypeName typeName, List<TDColumnType> elementTypes) {
        this.typeName = typeName;
        this.elementTypes = elementTypes;
    }

    public TDTypeName getTypeName() {
        return this.typeName;
    }

    public boolean isPrimitive() {
        return this.elementTypes.size() == 0;
    }

    public boolean isArrayType() {
        return this.typeName == TDTypeName.ARRAY;
    }

    public boolean isMapType() {
        return this.typeName == TDTypeName.MAP;
    }

    public TDColumnType getArrayElementType() {
        if (!this.isArrayType()) {
            throw new UnsupportedOperationException("getArrayElementType is not supported for " + this);
        }
        return this.elementTypes.get(0);
    }

    public TDColumnType getMapKeyType() {
        if (!this.isMapType()) {
            throw new UnsupportedOperationException("getmapKeyType is not supported for " + this);
        }
        return this.elementTypes.get(0);
    }

    public TDColumnType getMapValueType() {
        if (!this.isMapType()) {
            throw new UnsupportedOperationException("getMapValueType is not supported for " + this);
        }
        return this.elementTypes.get(1);
    }

    @JsonValue
    public String toString() {
        if (this.isArrayType()) {
            return String.format("array<%s>", this.getArrayElementType());
        }
        if (this.isMapType()) {
            return String.format("map<%s,%s>", this.getMapKeyType(), this.getMapValueType());
        }
        return this.typeName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TDColumnType that = (TDColumnType)o;
        if (!this.typeName.equals((Object)that.typeName)) {
            return false;
        }
        return Objects.equals(this.elementTypes, that.elementTypes);
    }

    public int hashCode() {
        int result = this.typeName != null ? this.typeName.hashCode() : 0;
        result = 31 * result + (this.elementTypes != null ? this.elementTypes.hashCode() : 0);
        return result;
    }

    public static TDColumnType parseColumnType(String str) {
        Parser p = new Parser(str);
        TDColumnType type = TDColumnType.parseColumnTypeRecursive(p);
        if (!p.eof()) {
            throw new IllegalArgumentException("Cannot parse type: EOF expected: " + str);
        }
        return type;
    }

    private static TDColumnType parseColumnTypeRecursive(Parser p) {
        if (p.scan("string")) {
            return STRING;
        }
        if (p.scan("int")) {
            return INT;
        }
        if (p.scan("long")) {
            return LONG;
        }
        if (p.scan("double")) {
            return DOUBLE;
        }
        if (p.scan("float")) {
            return FLOAT;
        }
        if (p.scan("array")) {
            if (!p.scan("<")) {
                throw new IllegalArgumentException("Cannot parse type: expected '<' for array type: " + p.getString());
            }
            TDColumnType elementType = TDColumnType.parseColumnTypeRecursive(p);
            if (!p.scan(">")) {
                throw new IllegalArgumentException("Cannot parse type: expected '>' for array type: " + p.getString());
            }
            return TDColumnType.newArrayType(elementType);
        }
        if (p.scan("map")) {
            if (!p.scan("<")) {
                throw new IllegalArgumentException("Cannot parse type: expected '<' for map type: " + p.getString());
            }
            TDColumnType keyType = TDColumnType.parseColumnTypeRecursive(p);
            if (!p.scan(",")) {
                throw new IllegalArgumentException("Cannot parse type: expected ',' for map type: " + p.getString());
            }
            TDColumnType valueType = TDColumnType.parseColumnTypeRecursive(p);
            if (!p.scan(">")) {
                throw new IllegalArgumentException("Cannot parse type: expected '>' for map type: " + p.getString());
            }
            return TDColumnType.newMapType(keyType, valueType);
        }
        throw new IllegalArgumentException("Cannot parse type: " + p.getString());
    }

    private static class Parser {
        private final String string;
        private int offset;

        public Parser(String string) {
            this.string = string;
        }

        public String getString() {
            return this.string;
        }

        public boolean scan(String s) {
            this.skipSpaces();
            if (this.string.startsWith(s, this.offset)) {
                this.offset += s.length();
                return true;
            }
            return false;
        }

        public boolean eof() {
            this.skipSpaces();
            return this.string.length() <= this.offset;
        }

        private void skipSpaces() {
            while (this.string.startsWith(" ", this.offset)) {
                ++this.offset;
            }
        }
    }
}

