/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.treasuredata.client.model.TDExportFileFormatType;
import com.treasuredata.client.model.TDExportJobRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TDExportJobRequest.of", generator="Immutables")
@NotThreadSafe
public final class TDExportJobRequestBuilder {
    private static final long INIT_BIT_DATABASE = 1L;
    private static final long INIT_BIT_TABLE = 2L;
    private static final long INIT_BIT_FROM = 4L;
    private static final long INIT_BIT_TO = 8L;
    private static final long INIT_BIT_FILE_FORMAT = 16L;
    private static final long INIT_BIT_ACCESS_KEY_ID = 32L;
    private static final long INIT_BIT_SECRET_ACCESS_KEY = 64L;
    private static final long INIT_BIT_BUCKET_NAME = 128L;
    private static final long INIT_BIT_FILE_PREFIX = 256L;
    private long initBits = 511L;
    @Nullable
    private String database;
    @Nullable
    private String table;
    @Nullable
    private Date from;
    @Nullable
    private Date to;
    @Nullable
    private TDExportFileFormatType fileFormat;
    @Nullable
    private String accessKeyId;
    @Nullable
    private String secretAccessKey;
    @Nullable
    private String bucketName;
    @Nullable
    private String filePrefix;
    private Optional<String> poolName = Optional.empty();
    private Optional<String> domainKey = Optional.empty();

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder database(String database) {
        this.database = Objects.requireNonNull(database, "database");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder table(String table) {
        this.table = Objects.requireNonNull(table, "table");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder from(Date from) {
        this.from = Objects.requireNonNull(from, "from");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder to(Date to) {
        this.to = Objects.requireNonNull(to, "to");
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder fileFormat(TDExportFileFormatType fileFormat) {
        this.fileFormat = Objects.requireNonNull(fileFormat, "fileFormat");
        this.initBits &= 0xFFFFFFFFFFFFFFEFL;
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder accessKeyId(String accessKeyId) {
        this.accessKeyId = Objects.requireNonNull(accessKeyId, "accessKeyId");
        this.initBits &= 0xFFFFFFFFFFFFFFDFL;
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder secretAccessKey(String secretAccessKey) {
        this.secretAccessKey = Objects.requireNonNull(secretAccessKey, "secretAccessKey");
        this.initBits &= 0xFFFFFFFFFFFFFFBFL;
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder bucketName(String bucketName) {
        this.bucketName = Objects.requireNonNull(bucketName, "bucketName");
        this.initBits &= 0xFFFFFFFFFFFFFF7FL;
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder filePrefix(String filePrefix) {
        this.filePrefix = Objects.requireNonNull(filePrefix, "filePrefix");
        this.initBits &= 0xFFFFFFFFFFFFFEFFL;
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder poolName(String poolName) {
        this.poolName = Optional.of(poolName);
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder poolName(Optional<String> poolName) {
        this.poolName = Objects.requireNonNull(poolName, "poolName");
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder domainKey(String domainKey) {
        this.domainKey = Optional.of(domainKey);
        return this;
    }

    @CanIgnoreReturnValue
    public final TDExportJobRequestBuilder domainKey(Optional<String> domainKey) {
        this.domainKey = Objects.requireNonNull(domainKey, "domainKey");
        return this;
    }

    public TDExportJobRequest build() {
        this.checkRequiredAttributes();
        return TDExportJobRequest.of(this.database, this.table, this.from, this.to, this.fileFormat, this.accessKeyId, this.secretAccessKey, this.bucketName, this.filePrefix, this.poolName, this.domainKey);
    }

    private boolean databaseIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean tableIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean fromIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private boolean toIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    private boolean fileFormatIsSet() {
        return (this.initBits & 0x10L) == 0L;
    }

    private boolean accessKeyIdIsSet() {
        return (this.initBits & 0x20L) == 0L;
    }

    private boolean secretAccessKeyIsSet() {
        return (this.initBits & 0x40L) == 0L;
    }

    private boolean bucketNameIsSet() {
        return (this.initBits & 0x80L) == 0L;
    }

    private boolean filePrefixIsSet() {
        return (this.initBits & 0x100L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.databaseIsSet()) {
            attributes.add("database");
        }
        if (!this.tableIsSet()) {
            attributes.add("table");
        }
        if (!this.fromIsSet()) {
            attributes.add("from");
        }
        if (!this.toIsSet()) {
            attributes.add("to");
        }
        if (!this.fileFormatIsSet()) {
            attributes.add("fileFormat");
        }
        if (!this.accessKeyIdIsSet()) {
            attributes.add("accessKeyId");
        }
        if (!this.secretAccessKeyIsSet()) {
            attributes.add("secretAccessKey");
        }
        if (!this.bucketNameIsSet()) {
            attributes.add("bucketName");
        }
        if (!this.filePrefixIsSet()) {
            attributes.add("filePrefix");
        }
        return "Cannot build of, some of required attributes are not set " + attributes;
    }
}

