/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.treasuredata.client.model.TDQuery;
import java.util.Optional;

public class TDJob {
    private final String jobId;
    private final Status status;
    private final Type type;
    private final String query;
    private final String createdAt;
    private final String startAt;
    private final String updatedAt;
    private final String endAt;
    private final Optional<String> resultSchema;
    private final String database;
    private final String result;
    private final String url;
    private final String userName;
    private final long duration;
    private final long resultSize;
    private final Optional<Debug> debug;
    private final long numRecords;
    private final Optional<EngineVersion> engineVersion;

    @JsonCreator
    static TDJob createTDJobV3(@JsonProperty(value="job_id") String jobId, @JsonProperty(value="status") Status status, @JsonProperty(value="type") Type type, @JsonProperty(value="query") TDQuery query, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="start_at") String startAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="end_at") String endAt, @JsonProperty(value="hive_result_schema") Optional<String> resultSchema, @JsonProperty(value="database") String database, @JsonProperty(value="result") String result, @JsonProperty(value="url") String url, @JsonProperty(value="user_name") String userName, @JsonProperty(value="duration") long duration, @JsonProperty(value="result_size") long resultSize, @JsonProperty(value="debug") Optional<Debug> debug, @JsonProperty(value="num_records") long numRecords, @JsonProperty(value="engine_version") Optional<EngineVersion> engineVersion) {
        return new TDJob(jobId, status, type, query.getQuery(), createdAt, startAt, updatedAt, endAt, resultSchema, database, result, url, userName, duration, resultSize, debug, numRecords, engineVersion);
    }

    public TDJob(String jobId, Status status, Type type, String query, String createdAt, String startAt, String updatedAt, String endAt, Optional<String> resultSchema, String database, String result, String url, String userName, long duration, long resultSize, Optional<Debug> debug, long numRecords, Optional<EngineVersion> engineVersion) {
        this.jobId = jobId;
        this.status = status;
        this.type = type;
        this.query = query;
        this.createdAt = createdAt;
        this.startAt = startAt;
        this.updatedAt = updatedAt;
        this.endAt = endAt;
        this.resultSchema = resultSchema;
        this.database = database;
        this.result = result;
        this.url = url;
        this.userName = userName;
        this.duration = duration;
        this.resultSize = resultSize;
        this.debug = debug;
        this.numRecords = numRecords;
        this.engineVersion = engineVersion;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Status getStatus() {
        return this.status;
    }

    public Type getType() {
        return this.type;
    }

    public String getQuery() {
        return this.query;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getStartAt() {
        return this.startAt;
    }

    public String getEndAt() {
        return this.endAt;
    }

    public Optional<String> getResultSchema() {
        return this.resultSchema;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getResult() {
        return this.result;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getResultSize() {
        return this.resultSize;
    }

    public Optional<Debug> getDebug() {
        return this.debug;
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public Optional<EngineVersion> getEngineVersion() {
        return this.engineVersion;
    }

    public String getCmdOut() {
        return this.debug.map(Debug::getCmdout).orElse("");
    }

    public String getStdErr() {
        return this.debug.map(Debug::getStderr).orElse("");
    }

    public String toString() {
        return "TDJob{jobId='" + this.jobId + '\'' + ", status=" + (Object)((Object)this.status) + ", type=" + (Object)((Object)this.type) + ", query=" + this.query + ", createdAt='" + this.createdAt + '\'' + ", startAt='" + this.startAt + '\'' + ", updatedAt='" + this.updatedAt + '\'' + ", endAt='" + this.endAt + '\'' + ", resultSchema=" + this.resultSchema + ", database='" + this.database + '\'' + ", result='" + this.result + '\'' + ", url='" + this.url + '\'' + ", userName='" + this.userName + '\'' + ", duration=" + this.duration + ", resultSize=" + this.resultSize + ", debug=" + this.debug + ", numRecords=" + this.numRecords + ", engineVersion=" + this.engineVersion + '}';
    }

    public static enum Status {
        QUEUED,
        BOOTING,
        RUNNING,
        SUCCESS,
        ERROR,
        KILLED,
        UNKNOWN;


        @JsonCreator
        public static Status fromString(String s) {
            return Status.valueOf(s.toUpperCase());
        }

        public boolean isFinished() {
            return this == SUCCESS || this == ERROR || this == KILLED;
        }
    }

    public static enum Type {
        HIVE("hive"),
        MAPRED("mapred"),
        PRESTO("presto"),
        PIG("pig"),
        BULKLOAD("bulkload"),
        EXPORT("export"),
        UNKNOWN("none");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        @JsonValue
        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }

        @JsonCreator
        public static Type fromString(String typeName) {
            for (Type t : Type.values()) {
                if (!t.type.equals(typeName)) continue;
                return t;
            }
            return UNKNOWN;
        }
    }

    private static class Debug {
        private final Optional<String> cmdout;
        private final Optional<String> stderr;

        @JsonCreator
        public Debug(@JsonProperty(value="cmdout") Optional<String> cmdout, @JsonProperty(value="stderr") Optional<String> stderr) {
            this.cmdout = cmdout;
            this.stderr = stderr;
        }

        public String getCmdout() {
            return this.cmdout.orElse("");
        }

        public String getStderr() {
            return this.stderr.orElse("");
        }

        public String toString() {
            return "Debug{cmdout='" + this.cmdout + '\'' + ", stderr='" + this.stderr + '\'' + '}';
        }
    }

    public static class EngineVersion {
        private final String engineVersion;

        private EngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @JsonValue
        public String getEngineVersion() {
            return this.engineVersion;
        }

        public String toString() {
            return this.engineVersion;
        }

        public static EngineVersion fromString(String engineVersion) {
            return new EngineVersion(engineVersion);
        }
    }

    public static enum Priority {
        VERYLOW(-2),
        LOW(-1),
        NORMAL(0),
        HIGH(1),
        VERYHIGH(2);

        private final int priority;

        private Priority(int priority) {
            this.priority = priority;
        }

        public int toInt() {
            return this.priority;
        }

        public static Priority fromInt(int priority) {
            for (Priority p : Priority.values()) {
                if (p.priority != priority) continue;
                return p;
            }
            return NORMAL;
        }
    }
}

