/*
 * Decompiled with CFR 0.152.
 */
package com.treasuredata.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.treasuredata.client.model.ImmutableTDSavedQueryStartRequestV4;
import com.treasuredata.client.model.TDSavedQueryStartRequest;
import java.text.SimpleDateFormat;
import java.util.Optional;
import java.util.TimeZone;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableTDSavedQueryStartRequestV4.class)
@JsonDeserialize(as=ImmutableTDSavedQueryStartRequestV4.class)
@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
public abstract class TDSavedQueryStartRequestV4 {
    @JsonProperty(value="scheduled_time")
    public abstract String scheduledTime();

    @JsonProperty(value="domain_key")
    public abstract Optional<String> domainKey();

    public static TDSavedQueryStartRequestV4 from(TDSavedQueryStartRequest request) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(tz);
        return TDSavedQueryStartRequestV4.builder().domainKey(request.domainKey()).scheduledTime(df.format(request.scheduledTime())).build();
    }

    public static Builder builder() {
        return ImmutableTDSavedQueryStartRequestV4.builder();
    }

    public static interface Builder {
        public Builder scheduledTime(String var1);

        public Builder domainKey(Optional<String> var1);

        public Builder domainKey(String var1);

        public TDSavedQueryStartRequestV4 build();
    }
}

