/*
 * Decompiled with CFR 0.152.
 */
package com.treblle.spring.utils;

import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    private static final String[] IP_HEADER_CANDIDATES = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};
    private static final String UNKNOWN = "unknown";

    private HttpUtils() {
    }

    public static String getClientAddress(HttpServletRequest request) {
        for (String header : IP_HEADER_CANDIDATES) {
            String ips = request.getHeader(header);
            if (ips == null || ips.length() == 0 || UNKNOWN.equalsIgnoreCase(ips)) continue;
            return ips.split(",")[0];
        }
        return request.getRemoteAddr();
    }
}

