/*
 * Decompiled with CFR 0.152.
 */
package com.treblle.spring;

import com.treblle.spring.dto.TrebllePayload;
import com.treblle.spring.service.TreblleService;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class TreblleFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(TreblleFilter.class);
    private final TreblleService service;

    public TreblleFilter(TreblleService service) {
        this.service = service;
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        String contentType = request.getContentType();
        if (contentType != null && !"application/json".equals(contentType)) {
            log.debug("Attempted to intercept request but content type was not valid. Treblle only works on JSON API's.");
            return true;
        }
        return super.shouldNotFilter(request);
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        ContentCachingRequestWrapper cachingRequest = new ContentCachingRequestWrapper(httpServletRequest);
        ContentCachingResponseWrapper cachingResponse = new ContentCachingResponseWrapper(httpServletResponse);
        Exception potentialException = null;
        long start = System.currentTimeMillis();
        try {
            filterChain.doFilter((ServletRequest)cachingRequest, (ServletResponse)cachingResponse);
        }
        catch (Exception exception) {
            potentialException = exception;
            throw exception;
        }
        finally {
            long responseTimeInMillis = System.currentTimeMillis() - start;
            byte[] requestBody = cachingRequest.getContentAsByteArray();
            byte[] responseBody = cachingResponse.getContentAsByteArray();
            cachingResponse.copyBodyToResponse();
            try {
                TrebllePayload payload = this.service.createPayload((HttpServletRequest)cachingRequest, (HttpServletResponse)cachingResponse, potentialException, responseTimeInMillis);
                this.service.maskAndSendPayload(payload, requestBody, responseBody, potentialException);
            }
            catch (Exception exception) {
                log.error("An error occurred while sending data to Treblle.", (Throwable)exception);
            }
        }
    }
}

