/*
 * Decompiled with CFR 0.152.
 */
package com.treblle.spring.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.treblle.spring.configuration.TreblleProperties;
import com.treblle.spring.dto.Data;
import com.treblle.spring.dto.Language;
import com.treblle.spring.dto.OperatingSystem;
import com.treblle.spring.dto.Request;
import com.treblle.spring.dto.Response;
import com.treblle.spring.dto.RuntimeError;
import com.treblle.spring.dto.Server;
import com.treblle.spring.dto.TrebllePayload;
import com.treblle.spring.service.TreblleService;
import com.treblle.spring.utils.HttpUtils;
import com.treblle.spring.utils.JsonMasker;
import java.io.IOException;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class TreblleServiceImpl
implements TreblleService {
    private static final Logger log = LoggerFactory.getLogger(TreblleServiceImpl.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String TREBLLE_API_ENDPOINT = "https://rocknrolla.treblle.com";
    private static final String TREBLLE_API_KEY_HEADER = "x-api-key";
    @Autowired
    private Environment environment;
    @Autowired
    private TreblleProperties properties;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private JsonMasker jsonMasker;
    @Autowired
    private RestTemplateBuilder restTemplateBuilder;
    private RestTemplate client;

    @PostConstruct
    private void init() {
        if (!StringUtils.hasLength((String)this.properties.getApiKey())) {
            throw new IllegalStateException("Treblle API key is required.");
        }
        if (!StringUtils.hasLength((String)this.properties.getProjectId())) {
            throw new IllegalStateException("Treblle Project ID is required.");
        }
        this.client = this.restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(1L)).setReadTimeout(Duration.ofSeconds(1L)).build();
    }

    @Override
    public TrebllePayload createPayload(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Exception chainException, long responseTimeInMillis) {
        Language language = new Language();
        language.setName("java");
        language.setVersion(System.getProperty("java.version"));
        OperatingSystem os = new OperatingSystem();
        os.setName(System.getProperty("os.name"));
        os.setArchitecture(System.getProperty("os.arch"));
        os.setRelease(System.getProperty("os.version"));
        Server server = new Server();
        server.setIp(this.environment.getProperty("server.address"));
        server.setTimezone(TimeZone.getDefault().getID());
        server.setProtocol(httpRequest.getProtocol());
        server.setOs(os);
        Request request = new Request();
        request.setTimestamp(ZonedDateTime.now(ZoneOffset.UTC).format(DATE_TIME_FORMATTER));
        request.setIp(HttpUtils.getClientAddress(httpRequest));
        request.setUserAgent(httpRequest.getHeader("User-Agent"));
        request.setMethod(httpRequest.getMethod());
        request.setUrl(ServletUriComponentsBuilder.fromRequestUri((HttpServletRequest)httpRequest).toUriString());
        Map<String, String> requestHeaders = this.readHeaders(Collections.list(httpRequest.getHeaderNames()), arg_0 -> ((HttpServletRequest)httpRequest).getHeader(arg_0));
        if (!requestHeaders.isEmpty()) {
            request.setHeaders(requestHeaders);
        }
        Response response = new Response();
        response.setCode(chainException != null ? 500 : httpResponse.getStatus());
        response.setLoadTime(Double.valueOf((float)responseTimeInMillis / 1000.0f));
        Map<String, String> responseHeaders = this.readHeaders(Optional.ofNullable(httpResponse.getHeaderNames()).orElseGet(Collections::emptyList), arg_0 -> ((HttpServletResponse)httpResponse).getHeader(arg_0));
        if (!responseHeaders.isEmpty()) {
            response.setHeaders(responseHeaders);
        }
        Data data = new Data();
        data.setServer(server);
        data.setLanguage(language);
        data.setRequest(request);
        data.setResponse(response);
        TrebllePayload payload = new TrebllePayload();
        payload.setApiKey(this.properties.getApiKey());
        payload.setProjectId(this.properties.getProjectId());
        payload.setData(data);
        return payload;
    }

    @Override
    @Async
    public void maskAndSendPayload(TrebllePayload payload, byte[] requestBody, byte[] responseBody, Exception chainException) {
        try {
            ArrayList<RuntimeError> errors = new ArrayList<RuntimeError>(2);
            Request request = payload.getData().getRequest();
            request.setBody(Optional.ofNullable(this.readBody(requestBody, errors::add)).map(this.jsonMasker::mask).orElse(null));
            Response response = payload.getData().getResponse();
            response.setSize(Long.valueOf(responseBody.length));
            response.setBody(this.readBody(responseBody, errors::add));
            if (chainException != null) {
                StackTraceElement[] stackTrace = chainException.fillInStackTrace().getStackTrace();
                RuntimeError error = new RuntimeError();
                error.setSource("onError");
                error.setType(chainException.getClass().getName());
                error.setMessage(chainException.getMessage());
                error.setFile(Arrays.stream(stackTrace).findFirst().map(StackTraceElement::getFileName).orElse(null));
                error.setLine(Arrays.stream(stackTrace).findFirst().map(StackTraceElement::getLineNumber).orElse(null));
                errors.add(error);
            }
            if (!errors.isEmpty()) {
                payload.getData().setErrors(errors);
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set(TREBLLE_API_KEY_HEADER, this.properties.getApiKey());
            HttpEntity requestEntity = new HttpEntity((Object)payload, (MultiValueMap)headers);
            try {
                this.client.postForEntity(TREBLLE_API_ENDPOINT, (Object)requestEntity, Void.class, new Object[0]);
            }
            catch (RestClientException exception) {
                log.error("An error occurred while sending network request to Treblle.", (Throwable)exception);
            }
        }
        catch (Exception exception) {
            log.error("An error occurred while sending data to Treblle.", (Throwable)exception);
        }
    }

    private Map<String, String> readHeaders(Collection<String> headers, UnaryOperator<String> extractor) {
        return headers.stream().collect(Collectors.toMap(name -> name, extractor, (first, second) -> first));
    }

    private JsonNode readBody(byte[] body, Consumer<RuntimeError> errorConsumer) {
        if (body.length > 0) {
            try {
                return this.objectMapper.readTree(body, 0, body.length);
            }
            catch (IOException exception) {
                RuntimeError error = new RuntimeError();
                error.setSource("onShutdown");
                error.setType("INVALID_JSON");
                error.setMessage("Invalid JSON format");
                errorConsumer.accept(error);
                return null;
            }
        }
        return null;
    }
}

