/*
 * Decompiled with CFR 0.152.
 */
package com.treblle.spring.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.treblle.spring.configuration.TreblleProperties;
import com.treblle.spring.utils.JsonMasker;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class JsonMaskerImpl
implements JsonMasker {
    private static final Logger log = LoggerFactory.getLogger(JsonMaskerImpl.class);
    private static final List<String> DEFAULT_KEYWORDS = Arrays.asList("password", "pwd", "secret", "password_confirmation", "cc", "card_number", "ccv", "ssn", "credit_score");
    @Autowired
    private TreblleProperties properties;
    private Pattern pattern;

    @PostConstruct
    private void init() {
        HashSet<String> keywords = new HashSet<String>(9);
        keywords.addAll(DEFAULT_KEYWORDS);
        keywords.addAll(this.properties.getMaskingKeywords());
        String regex = keywords.stream().map(it -> "\\b" + it + "\\b").collect(Collectors.joining("|"));
        try {
            this.pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException exception) {
            log.error("Error while compiling regex with custom keywords. Continuing with default.");
            String defaultRegex = DEFAULT_KEYWORDS.stream().map(it -> "\\b" + it + "\\b").collect(Collectors.joining("|"));
            this.pattern = Pattern.compile(defaultRegex);
        }
    }

    @Override
    public JsonNode mask(JsonNode node) {
        return this.maskInternal(null, node);
    }

    private JsonNode maskInternal(String key, JsonNode target) {
        if (target.isTextual() && key != null && this.pattern.matcher(key).matches()) {
            return new TextNode(String.join((CharSequence)"", Collections.nCopies(target.asText().length(), "*")));
        }
        if (target.isObject()) {
            Iterator fields = target.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                ((ObjectNode)target).replace((String)field.getKey(), this.maskInternal((String)field.getKey(), (JsonNode)field.getValue()));
            }
        }
        if (target.isArray()) {
            for (int index = 0; index < target.size(); ++index) {
                ((ArrayNode)target).set(index, this.maskInternal(key, target.get(index)));
            }
        }
        return target;
    }
}

