/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle.navi;

import com.trello.navi.Event;
import com.trello.navi.NaviComponent;
import com.trello.navi.rx.RxNavi;
import com.trello.rxlifecycle.ActivityEvent;
import com.trello.rxlifecycle.ActivityLifecycleProvider;
import com.trello.rxlifecycle.RxLifecycle;
import com.trello.rxlifecycle.navi.NaviLifecycleMaps;
import com.trello.rxlifecycle.navi.RxUtils;
import rx.Observable;
import rx.subjects.BehaviorSubject;

final class ActivityLifecycleProviderImpl
implements ActivityLifecycleProvider {
    private final BehaviorSubject<ActivityEvent> lifecycleSubject = BehaviorSubject.create();

    public ActivityLifecycleProviderImpl(NaviComponent activity) {
        if (!activity.handlesEvents(new Event[]{Event.CREATE, Event.START, Event.RESUME, Event.PAUSE, Event.STOP, Event.DESTROY})) {
            throw new IllegalArgumentException("NaviComponent does not handle all required events");
        }
        RxNavi.observe((NaviComponent)activity, (Event)Event.ALL).map(NaviLifecycleMaps.ACTIVITY_EVENT_MAP).filter(RxUtils.notNull()).subscribe(this.lifecycleSubject);
    }

    public Observable<ActivityEvent> lifecycle() {
        return this.lifecycleSubject.asObservable();
    }

    public <T> Observable.Transformer<T, T> bindUntilEvent(ActivityEvent event) {
        return RxLifecycle.bindUntilActivityEvent(this.lifecycleSubject, (ActivityEvent)event);
    }

    public <T> Observable.Transformer<T, T> bindToLifecycle() {
        return RxLifecycle.bindActivity(this.lifecycleSubject);
    }
}

