/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle.navi;

import com.trello.navi.Event;
import com.trello.navi.NaviComponent;
import com.trello.navi.rx.RxNavi;
import com.trello.rxlifecycle.FragmentEvent;
import com.trello.rxlifecycle.FragmentLifecycleProvider;
import com.trello.rxlifecycle.RxLifecycle;
import com.trello.rxlifecycle.navi.NaviLifecycleMaps;
import com.trello.rxlifecycle.navi.RxUtils;
import rx.Observable;
import rx.subjects.BehaviorSubject;

final class FragmentLifecycleProviderImpl
implements FragmentLifecycleProvider {
    private final BehaviorSubject<FragmentEvent> lifecycleSubject = BehaviorSubject.create();

    public FragmentLifecycleProviderImpl(NaviComponent fragment) {
        if (!fragment.handlesEvents(new Event[]{Event.ATTACH, Event.CREATE, Event.CREATE_VIEW, Event.START, Event.RESUME, Event.PAUSE, Event.STOP, Event.DESTROY_VIEW, Event.DESTROY, Event.DETACH})) {
            throw new IllegalArgumentException("NaviComponent does not handle all required events");
        }
        RxNavi.observe((NaviComponent)fragment, (Event)Event.ALL).map(NaviLifecycleMaps.FRAGMENT_EVENT_MAP).filter(RxUtils.notNull()).subscribe(this.lifecycleSubject);
    }

    public Observable<FragmentEvent> lifecycle() {
        return this.lifecycleSubject.asObservable();
    }

    public <T> Observable.Transformer<T, T> bindUntilEvent(FragmentEvent event) {
        return RxLifecycle.bindUntilFragmentEvent(this.lifecycleSubject, (FragmentEvent)event);
    }

    public <T> Observable.Transformer<T, T> bindToLifecycle() {
        return RxLifecycle.bindFragment(this.lifecycleSubject);
    }
}

