/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle.navi;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import com.trello.navi.Event;
import com.trello.navi.NaviComponent;
import com.trello.navi.rx.RxNavi;
import com.trello.rxlifecycle.ActivityEvent;
import com.trello.rxlifecycle.ActivityLifecycleProvider;
import com.trello.rxlifecycle.LifecycleTransformer;
import com.trello.rxlifecycle.RxLifecycle;
import com.trello.rxlifecycle.navi.NaviLifecycleMaps;
import com.trello.rxlifecycle.navi.RxUtils;
import rx.Observable;
import rx.subjects.BehaviorSubject;

final class ActivityLifecycleProviderImpl
implements ActivityLifecycleProvider {
    private final BehaviorSubject<ActivityEvent> lifecycleSubject = BehaviorSubject.create();

    public ActivityLifecycleProviderImpl(NaviComponent activity) {
        if (!activity.handlesEvents(new Event[]{Event.CREATE, Event.START, Event.RESUME, Event.PAUSE, Event.STOP, Event.DESTROY})) {
            throw new IllegalArgumentException("NaviComponent does not handle all required events");
        }
        RxNavi.observe((NaviComponent)activity, (Event)Event.ALL).map(NaviLifecycleMaps.ACTIVITY_EVENT_MAP).filter(RxUtils.notNull()).subscribe(this.lifecycleSubject);
    }

    @NonNull
    @CheckResult
    public Observable<ActivityEvent> lifecycle() {
        return this.lifecycleSubject.asObservable();
    }

    @NonNull
    @CheckResult
    public <T> LifecycleTransformer<T> bindUntilEvent(@NonNull ActivityEvent event) {
        return RxLifecycle.bindUntilEvent(this.lifecycleSubject, (Object)event);
    }

    @NonNull
    @CheckResult
    public <T> LifecycleTransformer<T> bindToLifecycle() {
        return RxLifecycle.bindActivity(this.lifecycleSubject);
    }
}

