/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle;

import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import com.trello.rxlifecycle.Functions;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

final class TakeUntilGenerator {
    @NonNull
    @CheckResult
    static <T> Observable<T> takeUntilEvent(@NonNull Observable<T> lifecycle, final @NonNull T event) {
        return lifecycle.takeFirst(new Func1<T, Boolean>(){

            public Boolean call(T lifecycleEvent) {
                return lifecycleEvent.equals(event);
            }
        });
    }

    @NonNull
    @CheckResult
    static <T> Observable<Boolean> takeUntilCorrespondingEvent(@NonNull Observable<T> lifecycle, @NonNull Func1<T, T> correspondingEvents) {
        return Observable.combineLatest((Observable)lifecycle.take(1).map(correspondingEvents), (Observable)lifecycle.skip(1), (Func2)new Func2<T, T, Boolean>(){

            public Boolean call(T bindUntilEvent, T lifecycleEvent) {
                return lifecycleEvent.equals(bindUntilEvent);
            }
        }).onErrorReturn(Functions.RESUME_FUNCTION).takeFirst(Functions.SHOULD_COMPLETE);
    }

    private TakeUntilGenerator() {
        throw new AssertionError((Object)"No instances!");
    }
}

