/*
 * Decompiled with CFR 0.152.
 */
package com.trello.rxlifecycle;

import android.support.annotation.NonNull;
import com.trello.rxlifecycle.LifecycleTransformer;
import com.trello.rxlifecycle.TakeUntilGenerator;
import com.trello.rxlifecycle.UntilEventCompletableTransformer;
import com.trello.rxlifecycle.UntilEventSingleTransformer;
import rx.Completable;
import rx.Observable;
import rx.Single;

final class UntilEventObservableTransformer<T, R>
implements LifecycleTransformer<T> {
    final Observable<R> lifecycle;
    final R event;

    public UntilEventObservableTransformer(@NonNull Observable<R> lifecycle, @NonNull R event) {
        this.lifecycle = lifecycle;
        this.event = event;
    }

    public Observable<T> call(Observable<T> source) {
        return source.takeUntil(TakeUntilGenerator.takeUntilEvent(this.lifecycle, this.event));
    }

    @Override
    public Single.Transformer<T, T> forSingle() {
        return new UntilEventSingleTransformer(this.lifecycle, this.event);
    }

    @Override
    public Completable.CompletableTransformer forCompletable() {
        return new UntilEventCompletableTransformer<R>(this.lifecycle, this.event);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UntilEventObservableTransformer that = (UntilEventObservableTransformer)o;
        if (!this.lifecycle.equals(that.lifecycle)) {
            return false;
        }
        return this.event.equals(that.event);
    }

    public int hashCode() {
        int result = this.lifecycle.hashCode();
        result = 31 * result + this.event.hashCode();
        return result;
    }

    public String toString() {
        return "UntilEventObservableTransformer{lifecycle=" + this.lifecycle + ", event=" + this.event + '}';
    }
}

