/*
 * Decompiled with CFR 0.152.
 */
package com.trello.lifecycle2.android.lifecycle;

import android.arch.lifecycle.Lifecycle;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import com.trello.rxlifecycle2.LifecycleTransformer;
import com.trello.rxlifecycle2.OutsideLifecycleException;
import com.trello.rxlifecycle2.RxLifecycle;
import io.reactivex.Observable;
import io.reactivex.functions.Function;

public final class RxLifecycleAndroidLifecycle {
    private static final Function<Lifecycle.Event, Lifecycle.Event> LIFECYCLE = new Function<Lifecycle.Event, Lifecycle.Event>(){

        public Lifecycle.Event apply(Lifecycle.Event lastEvent) throws Exception {
            switch (lastEvent) {
                case ON_CREATE: {
                    return Lifecycle.Event.ON_DESTROY;
                }
                case ON_START: {
                    return Lifecycle.Event.ON_STOP;
                }
                case ON_RESUME: {
                    return Lifecycle.Event.ON_PAUSE;
                }
                case ON_PAUSE: {
                    return Lifecycle.Event.ON_STOP;
                }
                case ON_STOP: {
                    return Lifecycle.Event.ON_DESTROY;
                }
                case ON_DESTROY: {
                    throw new OutsideLifecycleException("Cannot bind to Activity lifecycle when outside of it.");
                }
            }
            throw new UnsupportedOperationException("Binding to " + lastEvent + " not yet implemented");
        }
    };

    private RxLifecycleAndroidLifecycle() {
        throw new AssertionError((Object)"No instances");
    }

    @NonNull
    @CheckResult
    public static <T> LifecycleTransformer<T> bindLifecycle(@NonNull Observable<Lifecycle.Event> lifecycle) {
        return RxLifecycle.bind(lifecycle, LIFECYCLE);
    }
}

