/*
 * Decompiled with CFR 0.152.
 */
package com.trendyol.medusalib.navigator;

import com.trendyol.medusalib.common.extensions.StackExtensionsKt;
import com.trendyol.medusalib.navigator.data.StackItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eJ\u0015\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u00c6\u0003J/\u0010\u0011\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0013\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u0013J\u0006\u0010\u001b\u001a\u00020\u0013J\t\u0010\u001c\u001a\u00020\u0007H\u00d6\u0001J\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\u001f\u001a\u00020\u0013J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0007J\u0016\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0005J\u0016\u0010%\u001a\n \u0016*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0019\u001a\u00020\u0007J\b\u0010&\u001a\u0004\u0018\u00010\u0005J\u000e\u0010'\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010(\u001a\u00020\u0005J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050*2\u0006\u0010+\u001a\u00020,J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050*J\u0006\u0010.\u001a\u00020\u0007J\u000e\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u0007J\u000e\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u0000J\u000e\u00103\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0007J\t\u00104\u001a\u00020,H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u00065"}, d2={"Lcom/trendyol/medusalib/navigator/FragmentStackState;", "", "fragmentTagStack", "", "Ljava/util/Stack;", "Lcom/trendyol/medusalib/navigator/data/StackItem;", "tabIndexStack", "", "(Ljava/util/List;Ljava/util/Stack;)V", "getFragmentTagStack", "()Ljava/util/List;", "getTabIndexStack", "()Ljava/util/Stack;", "clear", "", "component1", "component2", "copy", "equals", "", "other", "getSelectedTabIndex", "kotlin.jvm.PlatformType", "()Ljava/lang/Integer;", "hasOnlyRoot", "tabIndex", "hasSelectedTabOnlyRoot", "hasTabStack", "hashCode", "insertTabToBottom", "isSelectedTab", "isSelectedTabEmpty", "isTabEmpty", "index", "notifyStackItemAdd", "stackItem", "notifyStackItemAddToCurrentTab", "peekItem", "peekItemFromSelectedTab", "popItem", "popItemFromSelectedTab", "popItems", "", "groupName", "", "popItemsFromNonEmptyTabs", "popSelectedTab", "setStackCount", "size", "setStackState", "stackState", "switchTab", "toString", "medusalib_release"})
public final class FragmentStackState {
    @NotNull
    private final List<Stack<StackItem>> fragmentTagStack;
    @NotNull
    private final Stack<Integer> tabIndexStack;

    public FragmentStackState(@NotNull List<Stack<StackItem>> fragmentTagStack, @NotNull Stack<Integer> tabIndexStack) {
        Intrinsics.checkNotNullParameter(fragmentTagStack, (String)"fragmentTagStack");
        Intrinsics.checkNotNullParameter(tabIndexStack, (String)"tabIndexStack");
        this.fragmentTagStack = fragmentTagStack;
        this.tabIndexStack = tabIndexStack;
    }

    public /* synthetic */ FragmentStackState(List list, Stack stack, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        if ((n & 2) != 0) {
            stack = new Stack<Integer>();
        }
        this(list, stack);
    }

    @NotNull
    public final List<Stack<StackItem>> getFragmentTagStack() {
        return this.fragmentTagStack;
    }

    @NotNull
    public final Stack<Integer> getTabIndexStack() {
        return this.tabIndexStack;
    }

    public final Integer getSelectedTabIndex() {
        return this.tabIndexStack.peek();
    }

    public final boolean isSelectedTabEmpty() {
        Integer n = this.getSelectedTabIndex();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getSelectedTabIndex()");
        return this.isTabEmpty(((Number)n).intValue());
    }

    public final boolean isTabEmpty(int index) {
        return this.fragmentTagStack.get(index).isEmpty();
    }

    public final void notifyStackItemAdd(int tabIndex, @NotNull StackItem stackItem) {
        Intrinsics.checkNotNullParameter((Object)stackItem, (String)"stackItem");
        Stack<StackItem> stack = this.fragmentTagStack.get(tabIndex);
        stack.push(stackItem);
    }

    public final void notifyStackItemAddToCurrentTab(@NotNull StackItem stackItem) {
        Intrinsics.checkNotNullParameter((Object)stackItem, (String)"stackItem");
        Integer n = this.getSelectedTabIndex();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getSelectedTabIndex()");
        this.notifyStackItemAdd(((Number)n).intValue(), stackItem);
    }

    public final void setStackCount(int size) {
        for (int index = 0; index < size; ++index) {
            this.fragmentTagStack.add(new Stack());
        }
    }

    public final void clear() {
        this.fragmentTagStack.clear();
        this.tabIndexStack.clear();
    }

    public final void switchTab(int tabIndex) {
        if (!this.tabIndexStack.contains(tabIndex)) {
            this.tabIndexStack.push(tabIndex);
        } else {
            StackExtensionsKt.moveToTop(this.tabIndexStack, tabIndex);
        }
    }

    public final boolean isSelectedTab(int tabIndex) {
        Integer n = this.getSelectedTabIndex();
        int n2 = tabIndex;
        return n != null && n == n2;
    }

    public final boolean hasOnlyRoot(int tabIndex) {
        return this.fragmentTagStack.get(tabIndex).size() <= 1;
    }

    public final boolean hasSelectedTabOnlyRoot() {
        Integer n = this.getSelectedTabIndex();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getSelectedTabIndex()");
        return this.fragmentTagStack.get(((Number)n).intValue()).size() <= 1;
    }

    @Nullable
    public final StackItem peekItemFromSelectedTab() {
        Stack<StackItem> stack;
        Integer n = this.getSelectedTabIndex();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getSelectedTabIndex()");
        Stack<StackItem> it = stack = this.fragmentTagStack.get(((Number)n).intValue());
        boolean bl = false;
        Stack<StackItem> stack2 = !((Collection)it).isEmpty() ? stack : null;
        return stack2 != null ? stack2.peek() : null;
    }

    @NotNull
    public final StackItem popItem(int tabIndex) {
        StackItem item = this.fragmentTagStack.get(tabIndex).pop();
        if (this.isTabEmpty(tabIndex)) {
            Integer n = this.getSelectedTabIndex();
            if (n != null && tabIndex == n && this.tabIndexStack.size() > 1) {
                this.popSelectedTab();
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"item");
        return item;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<StackItem> popItemsFromNonEmptyTabs() {
        List list;
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.fragmentTagStack;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Stack it = (Stack)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)it).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Stack stackItem = (Stack)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = stackItem;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StackItem stackItem2 = (StackItem)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        this.fragmentTagStack.clear();
        return list;
    }

    public final void insertTabToBottom(int tabIndex) {
        StackExtensionsKt.insertToBottom(this.tabIndexStack, tabIndex);
    }

    @NotNull
    public final List<StackItem> popItems(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Integer currentTabIndex = this.getSelectedTabIndex();
        Integer n = this.getSelectedTabIndex();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getSelectedTabIndex()");
        Stack<StackItem> currentTabStack = this.fragmentTagStack.get(((Number)n).intValue());
        Stack updatedTabStack = new Stack();
        updatedTabStack.push(currentTabStack.get(0));
        ArrayList<StackItem> deletedStackItems = new ArrayList<StackItem>();
        int n2 = currentTabStack.size();
        for (int i = 1; i < n2; ++i) {
            StackItem stackItem = (StackItem)currentTabStack.get(i);
            if (Intrinsics.areEqual((Object)groupName, (Object)stackItem.getGroupName())) {
                deletedStackItems.add(stackItem);
                continue;
            }
            updatedTabStack.push(stackItem);
        }
        if (!deletedStackItems.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)currentTabIndex, (String)"currentTabIndex");
            this.fragmentTagStack.set(currentTabIndex, updatedTabStack);
        }
        return deletedStackItems;
    }

    public final boolean hasTabStack() {
        return this.tabIndexStack.size() == 1;
    }

    public final void setStackState(@NotNull FragmentStackState stackState) {
        Intrinsics.checkNotNullParameter((Object)stackState, (String)"stackState");
        this.fragmentTagStack.addAll((Collection<Stack<StackItem>>)stackState.fragmentTagStack);
        this.tabIndexStack.addAll((Collection<Integer>)stackState.tabIndexStack);
    }

    public final StackItem peekItem(int tabIndex) {
        return this.fragmentTagStack.get(tabIndex).peek();
    }

    @NotNull
    public final StackItem popItemFromSelectedTab() {
        Integer n = this.getSelectedTabIndex();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getSelectedTabIndex()");
        return this.popItem(((Number)n).intValue());
    }

    public final int popSelectedTab() {
        Integer n = this.tabIndexStack.pop();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"tabIndexStack.pop()");
        return ((Number)n).intValue();
    }

    @NotNull
    public final List<Stack<StackItem>> component1() {
        return this.fragmentTagStack;
    }

    @NotNull
    public final Stack<Integer> component2() {
        return this.tabIndexStack;
    }

    @NotNull
    public final FragmentStackState copy(@NotNull List<Stack<StackItem>> fragmentTagStack, @NotNull Stack<Integer> tabIndexStack) {
        Intrinsics.checkNotNullParameter(fragmentTagStack, (String)"fragmentTagStack");
        Intrinsics.checkNotNullParameter(tabIndexStack, (String)"tabIndexStack");
        return new FragmentStackState(fragmentTagStack, tabIndexStack);
    }

    public static /* synthetic */ FragmentStackState copy$default(FragmentStackState fragmentStackState, List list, Stack stack, int n, Object object) {
        if ((n & 1) != 0) {
            list = fragmentStackState.fragmentTagStack;
        }
        if ((n & 2) != 0) {
            stack = fragmentStackState.tabIndexStack;
        }
        return fragmentStackState.copy(list, stack);
    }

    @NotNull
    public String toString() {
        return "FragmentStackState(fragmentTagStack=" + this.fragmentTagStack + ", tabIndexStack=" + this.tabIndexStack + ')';
    }

    public int hashCode() {
        int result = ((Object)this.fragmentTagStack).hashCode();
        result = result * 31 + this.tabIndexStack.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FragmentStackState)) {
            return false;
        }
        FragmentStackState fragmentStackState = (FragmentStackState)other;
        if (!Intrinsics.areEqual(this.fragmentTagStack, fragmentStackState.fragmentTagStack)) {
            return false;
        }
        return Intrinsics.areEqual(this.tabIndexStack, fragmentStackState.tabIndexStack);
    }

    public FragmentStackState() {
        this(null, null, 3, null);
    }
}

