/*
 * Decompiled with CFR 0.152.
 */
package com.trendyol.medusalib.navigator;

import android.os.Bundle;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import com.trendyol.medusalib.navigator.FragmentStackState;
import com.trendyol.medusalib.navigator.FragmentStackStateMapper;
import com.trendyol.medusalib.navigator.Navigator;
import com.trendyol.medusalib.navigator.NavigatorConfiguration;
import com.trendyol.medusalib.navigator.controller.FragmentManagerController;
import com.trendyol.medusalib.navigator.data.FragmentData;
import com.trendyol.medusalib.navigator.data.StackItem;
import com.trendyol.medusalib.navigator.tag.TagCreator;
import com.trendyol.medusalib.navigator.tag.UniqueTagCreator;
import com.trendyol.medusalib.navigator.transitionanimation.TransitionAnimationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 A2\u00020\u0001:\u0001ABK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010&\u001a\u00020$H\u0002J\u0010\u0010'\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0005H\u0002J\b\u0010(\u001a\u00020\u001fH\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0005H\u0016J\u0012\u0010*\u001a\u00020\u001f2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u00020\u001fH\u0002J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\tH\u0002J$\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u0002032\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001f05H\u0016J\u0010\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020,H\u0016J\b\u00108\u001a\u00020\u001fH\u0016J\u0018\u00108\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0010\u00109\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001cH\u0016J\u001c\u0010:\u001a\u00020\u001f2\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007H\u0016J\b\u0010;\u001a\u00020\u001cH\u0002J\b\u0010<\u001a\u00020\u001cH\u0002J\b\u0010=\u001a\u00020\u001fH\u0002J\u0010\u0010>\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\tH\u0016J\u0018\u0010>\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\t2\u0006\u0010?\u001a\u00020\u000fH\u0016J\u0018\u0010>\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u0005H\u0016J \u0010>\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010>\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0016J\"\u0010>\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\b\u0010?\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010@\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0016R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/trendyol/medusalib/navigator/MultipleStackNavigator;", "Lcom/trendyol/medusalib/navigator/Navigator;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "containerId", "", "rootFragmentProvider", "", "Lkotlin/Function0;", "Landroidx/fragment/app/Fragment;", "navigatorListener", "Lcom/trendyol/medusalib/navigator/Navigator$NavigatorListener;", "navigatorConfiguration", "Lcom/trendyol/medusalib/navigator/NavigatorConfiguration;", "transitionAnimationType", "Lcom/trendyol/medusalib/navigator/transitionanimation/TransitionAnimationType;", "(Landroidx/fragment/app/FragmentManager;ILjava/util/List;Lcom/trendyol/medusalib/navigator/Navigator$NavigatorListener;Lcom/trendyol/medusalib/navigator/NavigatorConfiguration;Lcom/trendyol/medusalib/navigator/transitionanimation/TransitionAnimationType;)V", "destinationChangeLiveData", "Landroidx/lifecycle/MutableLiveData;", "fragmentManagerController", "Lcom/trendyol/medusalib/navigator/controller/FragmentManagerController;", "fragmentStackState", "Lcom/trendyol/medusalib/navigator/FragmentStackState;", "fragmentStackStateMapper", "Lcom/trendyol/medusalib/navigator/FragmentStackStateMapper;", "tagCreator", "Lcom/trendyol/medusalib/navigator/tag/TagCreator;", "canFragmentGoBack", "", "canGoBack", "clearAllFragments", "", "tabIndex", "resetRootFragment", "clearGroup", "fragmentGroupName", "", "getCurrentFragment", "getCurrentFragmentTag", "getRootFragment", "goBack", "hasOnlyRoot", "initialize", "savedState", "Landroid/os/Bundle;", "initializeStackState", "loadStackStateFromSavedState", "notifyFragmentDestinationChange", "fragment", "observeDestinationChanges", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "destinationChangedListener", "Lkotlin/Function1;", "onSaveInstanceState", "outState", "reset", "resetCurrentTab", "resetWithFragmentProvider", "shouldExit", "shouldGoBackToInitialIndex", "showUpperFragment", "start", "transitionAnimation", "switchTab", "Companion", "medusalib_release"})
public class MultipleStackNavigator
implements Navigator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<? extends Function0<? extends Fragment>> rootFragmentProvider;
    @Nullable
    private Navigator.NavigatorListener navigatorListener;
    @NotNull
    private final NavigatorConfiguration navigatorConfiguration;
    @Nullable
    private final TransitionAnimationType transitionAnimationType;
    @NotNull
    private MutableLiveData<Fragment> destinationChangeLiveData;
    @NotNull
    private final TagCreator tagCreator;
    @NotNull
    private final FragmentManagerController fragmentManagerController;
    @NotNull
    private final FragmentStackStateMapper fragmentStackStateMapper;
    @NotNull
    private FragmentStackState fragmentStackState;
    @NotNull
    public static final String DEFAULT_GROUP_NAME = "";
    @NotNull
    public static final String MEDUSA_STACK_STATE_KEY = "MEDUSA_STACK_STATE_KEY";

    public MultipleStackNavigator(@NotNull FragmentManager fragmentManager, int containerId, @NotNull List<? extends Function0<? extends Fragment>> rootFragmentProvider, @Nullable Navigator.NavigatorListener navigatorListener, @NotNull NavigatorConfiguration navigatorConfiguration, @Nullable TransitionAnimationType transitionAnimationType) {
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter(rootFragmentProvider, (String)"rootFragmentProvider");
        Intrinsics.checkNotNullParameter((Object)navigatorConfiguration, (String)"navigatorConfiguration");
        this.rootFragmentProvider = rootFragmentProvider;
        this.navigatorListener = navigatorListener;
        this.navigatorConfiguration = navigatorConfiguration;
        this.transitionAnimationType = transitionAnimationType;
        this.destinationChangeLiveData = new MutableLiveData();
        this.tagCreator = new UniqueTagCreator();
        this.fragmentManagerController = new FragmentManagerController(fragmentManager, containerId, this.navigatorConfiguration.getDefaultNavigatorTransaction());
        this.fragmentStackStateMapper = new FragmentStackStateMapper();
        this.fragmentStackState = new FragmentStackState(null, null, 3, null);
    }

    public /* synthetic */ MultipleStackNavigator(FragmentManager fragmentManager, int n, List list, Navigator.NavigatorListener navigatorListener, NavigatorConfiguration navigatorConfiguration, TransitionAnimationType transitionAnimationType, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            navigatorListener = null;
        }
        if ((n2 & 0x10) != 0) {
            navigatorConfiguration = new NavigatorConfiguration(0, false, null, 7, null);
        }
        if ((n2 & 0x20) != 0) {
            transitionAnimationType = null;
        }
        this(fragmentManager, n, list, navigatorListener, navigatorConfiguration, transitionAnimationType);
    }

    @Override
    public void start(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.start(fragment, DEFAULT_GROUP_NAME);
    }

    @Override
    public void start(@NotNull Fragment fragment, int tabIndex) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.start(fragment, tabIndex, DEFAULT_GROUP_NAME);
    }

    @Override
    public void start(@NotNull Fragment fragment, int tabIndex, @NotNull String fragmentGroupName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter((Object)fragmentGroupName, (String)"fragmentGroupName");
            this.switchTab(tabIndex);
            this.start(fragment, fragmentGroupName);
            Navigator.NavigatorListener navigatorListener = this.navigatorListener;
            if (navigatorListener == null) break block0;
            navigatorListener.onTabChanged(tabIndex);
        }
    }

    @Override
    public void start(@NotNull Fragment fragment, @NotNull String fragmentGroupName) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)fragmentGroupName, (String)"fragmentGroupName");
        this.start(fragment, fragmentGroupName, this.transitionAnimationType);
    }

    @Override
    public void start(@NotNull Fragment fragment, @NotNull TransitionAnimationType transitionAnimation) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)((Object)transitionAnimation), (String)"transitionAnimation");
        this.start(fragment, DEFAULT_GROUP_NAME, transitionAnimation);
    }

    @Override
    public void start(@NotNull Fragment fragment, @NotNull String fragmentGroupName, @Nullable TransitionAnimationType transitionAnimation) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)fragmentGroupName, (String)"fragmentGroupName");
        String createdTag = this.tagCreator.create(fragment);
        Integer currentTabIndex = this.fragmentStackState.getSelectedTabIndex();
        FragmentData fragmentData = new FragmentData(fragment, createdTag, transitionAnimation);
        if (this.fragmentStackState.isSelectedTabEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)currentTabIndex, (String)"currentTabIndex");
            Fragment rootFragment = this.getRootFragment(currentTabIndex);
            String rootFragmentTag = this.tagCreator.create(rootFragment);
            FragmentData rootFragmentData = new FragmentData(rootFragment, rootFragmentTag, transitionAnimation);
            FragmentData[] fragmentDataArray = new FragmentData[]{rootFragmentData, fragmentData};
            this.fragmentManagerController.disableAndStartFragment(this.getCurrentFragmentTag(), fragmentDataArray);
        } else {
            FragmentData[] fragmentDataArray = new FragmentData[]{fragmentData};
            this.fragmentManagerController.disableAndStartFragment(this.getCurrentFragmentTag(), fragmentDataArray);
        }
        this.fragmentStackState.notifyStackItemAddToCurrentTab(new StackItem(createdTag, fragmentGroupName));
        this.notifyFragmentDestinationChange(fragment);
    }

    @Override
    public void goBack() {
        if (!this.canGoBack()) {
            throw new IllegalStateException("Can not call goBack() method because stack is empty.");
        }
        if (!this.canFragmentGoBack()) {
            return;
        }
        if (this.shouldExit() && this.shouldGoBackToInitialIndex()) {
            this.fragmentStackState.insertTabToBottom(this.navigatorConfiguration.getInitialTabIndex());
        }
        if (this.fragmentStackState.hasSelectedTabOnlyRoot()) {
            this.fragmentManagerController.disableFragment(this.getCurrentFragmentTag());
            this.fragmentStackState.popSelectedTab();
            Navigator.NavigatorListener navigatorListener = this.navigatorListener;
            if (navigatorListener != null) {
                Integer n = this.fragmentStackState.getSelectedTabIndex();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"fragmentStackState.getSelectedTabIndex()");
                navigatorListener.onTabChanged(((Number)n).intValue());
            }
        } else {
            String currentFragmentTag = this.fragmentStackState.popItemFromSelectedTab().getFragmentTag();
            this.fragmentManagerController.removeFragment(currentFragmentTag);
        }
        this.showUpperFragment();
    }

    @Override
    public boolean canGoBack() {
        return !this.shouldExit() || this.shouldGoBackToInitialIndex();
    }

    @Override
    public void switchTab(int tabIndex) {
        block1: {
            if (this.fragmentStackState.isSelectedTab(tabIndex)) {
                return;
            }
            this.fragmentManagerController.disableFragment(this.getCurrentFragmentTag());
            this.fragmentStackState.switchTab(tabIndex);
            this.showUpperFragment();
            Navigator.NavigatorListener navigatorListener = this.navigatorListener;
            if (navigatorListener == null) break block1;
            navigatorListener.onTabChanged(tabIndex);
        }
    }

    @Override
    public void reset(int tabIndex, boolean resetRootFragment) {
        if (this.fragmentStackState.isSelectedTab(tabIndex)) {
            this.resetCurrentTab(resetRootFragment);
            return;
        }
        this.clearAllFragments(tabIndex, resetRootFragment);
    }

    @Override
    public void resetCurrentTab(boolean resetRootFragment) {
        Integer currentTabIndex = this.fragmentStackState.getSelectedTabIndex();
        Intrinsics.checkNotNullExpressionValue((Object)currentTabIndex, (String)"currentTabIndex");
        this.clearAllFragments(currentTabIndex, resetRootFragment);
        if (resetRootFragment) {
            Fragment rootFragment = this.getRootFragment(currentTabIndex);
            String createdTag = this.tagCreator.create(rootFragment);
            FragmentData rootFragmentData = new FragmentData(rootFragment, createdTag, null, 4, null);
            this.fragmentStackState.switchTab(currentTabIndex);
            this.fragmentStackState.notifyStackItemAdd(currentTabIndex, new StackItem(createdTag, null, 2, null));
            this.fragmentManagerController.addFragment(rootFragmentData);
            this.notifyFragmentDestinationChange(rootFragment);
        } else {
            String upperFragmentTag = this.getCurrentFragmentTag();
            Fragment upperFragment = this.fragmentManagerController.getFragment(upperFragmentTag);
            Fragment fragment = upperFragment;
            if (fragment == null) {
                fragment = this.getRootFragment(currentTabIndex);
            }
            Fragment newDestination = fragment;
            String newDestinationTag = this.tagCreator.create(newDestination);
            this.notifyFragmentDestinationChange(newDestination);
            this.fragmentManagerController.enableFragment(newDestinationTag);
        }
    }

    @Override
    public void reset() {
        this.clearAllFragments();
        this.fragmentStackState.clear();
        this.initializeStackState();
    }

    @Override
    public void resetWithFragmentProvider(@NotNull List<? extends Function0<? extends Fragment>> rootFragmentProvider) {
        Intrinsics.checkNotNullParameter(rootFragmentProvider, (String)"rootFragmentProvider");
        this.rootFragmentProvider = rootFragmentProvider;
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clearGroup(@NotNull String fragmentGroupName) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)fragmentGroupName, (String)"fragmentGroupName");
        if (Intrinsics.areEqual((Object)fragmentGroupName, (Object)DEFAULT_GROUP_NAME)) {
            throw new IllegalArgumentException("Fragment group name can not be empty.");
        }
        StackItem stackItem = this.fragmentStackState.peekItemFromSelectedTab();
        String upperFragmentTag = stackItem != null ? stackItem.getFragmentTag() : null;
        Iterable iterable = this.fragmentStackState.popItems(fragmentGroupName);
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StackItem stackItem2 = (StackItem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFragmentTag());
        }
        List poppedFragmentTags = (List)destination$iv$iv;
        if (!((Collection)poppedFragmentTags).isEmpty()) {
            this.fragmentManagerController.removeFragments(poppedFragmentTags);
            boolean poppedUpperFragment = CollectionsKt.contains((Iterable)poppedFragmentTags, (Object)upperFragmentTag);
            if (poppedUpperFragment) {
                this.showUpperFragment();
            }
        }
    }

    @Override
    public boolean hasOnlyRoot(int tabIndex) {
        return this.fragmentStackState.hasOnlyRoot(tabIndex);
    }

    @Override
    @Nullable
    public Fragment getCurrentFragment() {
        String visibleFragmentTag = this.getCurrentFragmentTag();
        return this.fragmentManagerController.getFragment(visibleFragmentTag);
    }

    @Override
    public void initialize(@Nullable Bundle savedState) {
        if (savedState == null) {
            this.initializeStackState();
        } else {
            this.loadStackStateFromSavedState(savedState);
        }
    }

    @Override
    public void observeDestinationChanges(@NotNull LifecycleOwner lifecycleOwner, @NotNull Function1<? super Fragment, Unit> destinationChangedListener) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter(destinationChangedListener, (String)"destinationChangedListener");
        this.destinationChangeLiveData.observe(lifecycleOwner, arg_0 -> MultipleStackNavigator.observeDestinationChanges$lambda$1(destinationChangedListener, arg_0));
    }

    private final void initializeStackState() {
        int initialTabIndex = this.navigatorConfiguration.getInitialTabIndex();
        Fragment rootFragment = (Fragment)this.rootFragmentProvider.get(initialTabIndex).invoke();
        String createdTag = this.tagCreator.create(rootFragment);
        StackItem stackItem = new StackItem(createdTag, null, 2, null);
        this.fragmentStackState.setStackCount(this.rootFragmentProvider.size());
        this.fragmentStackState.notifyStackItemAdd(initialTabIndex, stackItem);
        this.fragmentStackState.switchTab(initialTabIndex);
        String rootFragmentTag = this.fragmentStackState.peekItem(initialTabIndex).getFragmentTag();
        FragmentData rootFragmentData = new FragmentData(rootFragment, rootFragmentTag, null, 4, null);
        this.fragmentManagerController.addFragment(rootFragmentData);
        Navigator.NavigatorListener navigatorListener = this.navigatorListener;
        if (navigatorListener != null) {
            navigatorListener.onTabChanged(this.navigatorConfiguration.getInitialTabIndex());
        }
        this.notifyFragmentDestinationChange(rootFragment);
    }

    private final void loadStackStateFromSavedState(Bundle savedState) {
        block1: {
            FragmentStackState stackState = this.fragmentStackStateMapper.fromBundle(savedState.getBundle(MEDUSA_STACK_STATE_KEY));
            this.fragmentStackState.setStackState(stackState);
            if (!(!((Collection)stackState.getTabIndexStack()).isEmpty())) break block1;
            Navigator.NavigatorListener navigatorListener = this.navigatorListener;
            if (navigatorListener != null) {
                Integer n = this.fragmentStackState.getSelectedTabIndex();
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"fragmentStackState.getSelectedTabIndex()");
                navigatorListener.onTabChanged(((Number)n).intValue());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Fragment getRootFragment(int tabIndex) {
        Object object;
        Integer n;
        Integer n2 = tabIndex;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        Integer n3 = n = !this.fragmentStackState.isTabEmpty(it) ? n2 : null;
        if (n != null) {
            int it2 = ((Number)n).intValue();
            boolean bl2 = false;
            n2 = this.fragmentManagerController.getFragment(this.fragmentStackState.peekItem(it2).getFragmentTag());
            if (n2 != null) {
                object = n2;
                return object;
            }
        }
        object = (Fragment)this.rootFragmentProvider.get(tabIndex).invoke();
        return object;
    }

    private final void showUpperFragment() {
        Fragment upperFragment;
        Fragment fragment;
        String upperFragmentTag;
        StackItem stackItem = this.fragmentStackState.peekItemFromSelectedTab();
        String string = upperFragmentTag = stackItem != null ? stackItem.getFragmentTag() : null;
        if (string != null) {
            String it = string;
            boolean bl = false;
            fragment = this.fragmentManagerController.getFragment(it);
        } else {
            fragment = upperFragment = null;
        }
        if (upperFragmentTag == null || upperFragment == null) {
            Integer n = this.fragmentStackState.getSelectedTabIndex();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"fragmentStackState.getSelectedTabIndex()");
            Fragment rootFragment = this.getRootFragment(((Number)n).intValue());
            String createdTag = this.tagCreator.create(rootFragment);
            FragmentData rootFragmentData = new FragmentData(rootFragment, createdTag, null, 4, null);
            Integer n2 = this.fragmentStackState.getSelectedTabIndex();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"fragmentStackState.getSelectedTabIndex()");
            this.fragmentStackState.notifyStackItemAdd(((Number)n2).intValue(), new StackItem(createdTag, null, 2, null));
            this.fragmentManagerController.addFragment(rootFragmentData);
            this.notifyFragmentDestinationChange(rootFragment);
        } else {
            this.fragmentManagerController.enableFragment(upperFragmentTag);
            this.notifyFragmentDestinationChange(upperFragment);
        }
    }

    private final String getCurrentFragmentTag() {
        StackItem stackItem = this.fragmentStackState.peekItemFromSelectedTab();
        if (stackItem == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return stackItem.getFragmentTag();
    }

    private final boolean shouldExit() {
        return this.fragmentStackState.hasTabStack() && this.fragmentStackState.hasSelectedTabOnlyRoot();
    }

    private final boolean shouldGoBackToInitialIndex() {
        Integer n = this.fragmentStackState.getSelectedTabIndex();
        int n2 = this.navigatorConfiguration.getInitialTabIndex();
        return (n == null || n != n2) && this.navigatorConfiguration.getAlwaysExitFromInitial();
    }

    private final void clearAllFragments() {
        Iterable $this$forEach$iv = this.fragmentStackState.popItemsFromNonEmptyTabs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StackItem it = (StackItem)element$iv;
            boolean bl = false;
            this.fragmentManagerController.findFragmentByTagAndRemove(it.getFragmentTag());
        }
        this.fragmentManagerController.commitAllowingStateLoss();
    }

    private final void clearAllFragments(int tabIndex, boolean resetRootFragment) {
        if (this.fragmentStackState.isTabEmpty(tabIndex)) {
            return;
        }
        while (!(this.fragmentStackState.isTabEmpty(tabIndex) || this.fragmentStackState.hasOnlyRoot(tabIndex) && !resetRootFragment)) {
            String fragmentTagToBeRemoved = this.fragmentStackState.popItem(tabIndex).getFragmentTag();
            this.fragmentManagerController.findFragmentByTagAndRemove(fragmentTagToBeRemoved);
        }
        this.fragmentManagerController.commitAllowingStateLoss();
    }

    private final boolean canFragmentGoBack() {
        if (this.getCurrentFragment() instanceof Navigator.OnGoBackListener) {
            Fragment fragment = this.getCurrentFragment();
            Intrinsics.checkNotNull((Object)fragment, (String)"null cannot be cast to non-null type com.trendyol.medusalib.navigator.Navigator.OnGoBackListener");
            return ((Navigator.OnGoBackListener)fragment).onGoBack();
        }
        return true;
    }

    private final void notifyFragmentDestinationChange(Fragment fragment) {
        fragment.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(fragment, this){
            final /* synthetic */ Fragment $fragment;
            final /* synthetic */ MultipleStackNavigator this$0;
            {
                this.$fragment = $fragment;
                this.this$0 = $receiver;
            }

            public void onStart(@NotNull LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                owner.getLifecycle().removeObserver((LifecycleObserver)this);
                this.$fragment.getViewLifecycleOwner().getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(this.this$0, this.$fragment){
                    final /* synthetic */ MultipleStackNavigator this$0;
                    final /* synthetic */ Fragment $fragment;
                    {
                        this.this$0 = $receiver;
                        this.$fragment = $fragment;
                    }

                    public void onCreate(@NotNull LifecycleOwner owner) {
                        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                        MultipleStackNavigator.access$getDestinationChangeLiveData$p(this.this$0).setValue((Object)this.$fragment);
                    }

                    public void onDestroy(@NotNull LifecycleOwner owner) {
                        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                        if (Intrinsics.areEqual((Object)MultipleStackNavigator.access$getDestinationChangeLiveData$p(this.this$0).getValue(), (Object)this.$fragment)) {
                            MultipleStackNavigator.access$getDestinationChangeLiveData$p(this.this$0).setValue(null);
                        }
                        owner.getLifecycle().removeObserver((LifecycleObserver)this);
                    }
                });
            }
        });
    }

    @Override
    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        outState.putBundle(MEDUSA_STACK_STATE_KEY, this.fragmentStackStateMapper.toBundle(this.fragmentStackState));
    }

    private static final void observeDestinationChanges$lambda$1(Function1 $destinationChangedListener, Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)$destinationChangedListener, (String)"$destinationChangedListener");
        if (fragment != null) {
            $destinationChangedListener.invoke((Object)fragment);
        }
    }

    public static final /* synthetic */ MutableLiveData access$getDestinationChangeLiveData$p(MultipleStackNavigator $this) {
        return $this.destinationChangeLiveData;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/trendyol/medusalib/navigator/MultipleStackNavigator$Companion;", "", "()V", "DEFAULT_GROUP_NAME", "", "MEDUSA_STACK_STATE_KEY", "medusalib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

