/*
 * Decompiled with CFR 0.152.
 */
package com.trendyol.medusalib.navigator.controller;

import androidx.annotation.AnimRes;
import androidx.annotation.AnimatorRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.trendyol.medusalib.R;
import com.trendyol.medusalib.common.extensions.FragmentTransactionExtensionsKt;
import com.trendyol.medusalib.navigator.Navigator;
import com.trendyol.medusalib.navigator.data.FragmentData;
import com.trendyol.medusalib.navigator.transaction.NavigatorTransaction;
import com.trendyol.medusalib.navigator.transaction.TransactionType;
import com.trendyol.medusalib.navigator.transitionanimation.TransitionAnimationType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\u0006\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J'\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00152\u0012\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u001c\"\u00020\u0010\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010&\u001a\u00020\u000e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150(J\u001c\u0010)\u001a\u00020\u000e2\b\b\u0001\u0010*\u001a\u00020\u00052\b\b\u0001\u0010+\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/trendyol/medusalib/navigator/controller/FragmentManagerController;", "", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "containerId", "", "navigatorTransaction", "Lcom/trendyol/medusalib/navigator/transaction/NavigatorTransaction;", "(Landroidx/fragment/app/FragmentManager;ILcom/trendyol/medusalib/navigator/transaction/NavigatorTransaction;)V", "currentTransaction", "Landroidx/fragment/app/FragmentTransaction;", "currentTransitionAnimationType", "Lcom/trendyol/medusalib/navigator/transitionanimation/TransitionAnimationType;", "addFragment", "", "fragmentData", "Lcom/trendyol/medusalib/navigator/data/FragmentData;", "checkAndCreateTransaction", "commitAllowingStateLoss", "commitAttach", "fragmentTag", "", "commitDetach", "commitHide", "commitShow", "disableAndStartFragment", "disableFragmentTag", "fragmentDataArgs", "", "(Ljava/lang/String;[Lcom/trendyol/medusalib/navigator/data/FragmentData;)V", "disableFragment", "enableFragment", "findFragmentByTagAndRemove", "getFragment", "Landroidx/fragment/app/Fragment;", "getFragmentNavigatorTransaction", "getFragmentWithExecutingPendingTransactionsIfNeeded", "removeFragment", "removeFragments", "fragmentTagList", "", "setCustomAnimations", "enter", "exit", "medusalib_release"})
public final class FragmentManagerController {
    @NotNull
    private final FragmentManager fragmentManager;
    private final int containerId;
    @NotNull
    private final NavigatorTransaction navigatorTransaction;
    @Nullable
    private FragmentTransaction currentTransaction;
    @Nullable
    private TransitionAnimationType currentTransitionAnimationType;

    public FragmentManagerController(@NotNull FragmentManager fragmentManager, int containerId, @NotNull NavigatorTransaction navigatorTransaction) {
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)navigatorTransaction, (String)"navigatorTransaction");
        this.fragmentManager = fragmentManager;
        this.containerId = containerId;
        this.navigatorTransaction = navigatorTransaction;
    }

    public final void enableFragment(@NotNull String fragmentTag) {
        Intrinsics.checkNotNullParameter((Object)fragmentTag, (String)"fragmentTag");
        NavigatorTransaction navigatorTransaction = this.getFragmentNavigatorTransaction(fragmentTag);
        switch (WhenMappings.$EnumSwitchMapping$0[navigatorTransaction.getTransactionType().ordinal()]) {
            case 1: {
                this.commitShow(fragmentTag);
                break;
            }
            case 2: {
                this.commitAttach(fragmentTag);
            }
        }
    }

    public final void disableFragment(@NotNull String fragmentTag) {
        Intrinsics.checkNotNullParameter((Object)fragmentTag, (String)"fragmentTag");
        NavigatorTransaction navigatorTransaction = this.getFragmentNavigatorTransaction(fragmentTag);
        switch (WhenMappings.$EnumSwitchMapping$0[navigatorTransaction.getTransactionType().ordinal()]) {
            case 1: {
                this.commitHide(fragmentTag);
                break;
            }
            case 2: {
                this.commitDetach(fragmentTag);
            }
        }
    }

    public final void removeFragment(@NotNull String fragmentTag) {
        Intrinsics.checkNotNullParameter((Object)fragmentTag, (String)"fragmentTag");
        this.checkAndCreateTransaction();
        TransitionAnimationType transitionAnimationType = this.currentTransitionAnimationType;
        switch (transitionAnimationType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[transitionAnimationType.ordinal()]) {
            case 1: {
                this.setCustomAnimations(R.anim.empty_animation, R.anim.exit_to_left);
                break;
            }
            case 2: {
                this.setCustomAnimations(R.anim.empty_animation, R.anim.exit_to_right);
                break;
            }
            case 3: {
                this.setCustomAnimations(R.anim.empty_animation, R.anim.exit_to_bottom);
                break;
            }
            case 4: {
                this.setCustomAnimations(R.anim.empty_animation, R.anim.exit_to_top);
                break;
            }
            case 5: {
                this.setCustomAnimations(R.anim.empty_animation, R.anim.fade_out);
            }
        }
        FragmentTransaction fragmentTransaction = this.currentTransaction;
        if (fragmentTransaction != null) {
            FragmentTransactionExtensionsKt.remove(fragmentTransaction, this.getFragment(fragmentTag));
        }
        this.commitAllowingStateLoss();
    }

    public final void removeFragments(@NotNull List<String> fragmentTagList) {
        Intrinsics.checkNotNullParameter(fragmentTagList, (String)"fragmentTagList");
        this.checkAndCreateTransaction();
        for (String fragmentTag : fragmentTagList) {
            Fragment it;
            if (this.getFragment(fragmentTag) == null) continue;
            boolean bl = false;
            FragmentTransaction fragmentTransaction = this.currentTransaction;
            if (fragmentTransaction == null) continue;
            fragmentTransaction.remove(it);
        }
        this.commitAllowingStateLoss();
    }

    public final void addFragment(@NotNull FragmentData fragmentData) {
        Intrinsics.checkNotNullParameter((Object)fragmentData, (String)"fragmentData");
        this.checkAndCreateTransaction();
        FragmentTransaction fragmentTransaction = this.currentTransaction;
        if (fragmentTransaction != null) {
            fragmentTransaction.add(this.containerId, fragmentData.getFragment(), fragmentData.getFragmentTag());
        }
        this.commitAllowingStateLoss();
    }

    public final void disableAndStartFragment(@NotNull String disableFragmentTag, FragmentData ... fragmentDataArgs) {
        Intrinsics.checkNotNullParameter((Object)disableFragmentTag, (String)"disableFragmentTag");
        Intrinsics.checkNotNullParameter((Object)fragmentDataArgs, (String)"fragmentDataArgs");
        Fragment disabledFragment = this.getFragmentWithExecutingPendingTransactionsIfNeeded(disableFragmentTag);
        this.checkAndCreateTransaction();
        for (FragmentData fragmentData : fragmentDataArgs) {
            TransitionAnimationType transitionAnimationType = this.currentTransitionAnimationType = fragmentData.getTransitionAnimation();
            switch (transitionAnimationType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[transitionAnimationType.ordinal()]) {
                case 1: {
                    this.setCustomAnimations(R.anim.enter_from_left, R.anim.empty_animation);
                    break;
                }
                case 2: {
                    this.setCustomAnimations(R.anim.enter_from_right, R.anim.empty_animation);
                    break;
                }
                case 3: {
                    this.setCustomAnimations(R.anim.enter_from_bottom, R.anim.empty_animation);
                    break;
                }
                case 4: {
                    this.setCustomAnimations(R.anim.enter_from_top, R.anim.empty_animation);
                    break;
                }
                case 5: {
                    this.setCustomAnimations(R.anim.fade_in, R.anim.empty_animation);
                }
            }
            FragmentTransaction fragmentTransaction = this.currentTransaction;
            if (fragmentTransaction == null) continue;
            fragmentTransaction.add(this.containerId, fragmentData.getFragment(), fragmentData.getFragmentTag());
        }
        NavigatorTransaction disabledFragmentNavigatorTransaction = this.getFragmentNavigatorTransaction(disableFragmentTag);
        switch (WhenMappings.$EnumSwitchMapping$0[disabledFragmentNavigatorTransaction.getTransactionType().ordinal()]) {
            case 1: {
                FragmentTransaction fragmentTransaction = this.currentTransaction;
                if (fragmentTransaction != null) {
                    FragmentTransactionExtensionsKt.hide(fragmentTransaction, disabledFragment);
                }
                break;
            }
            case 2: {
                FragmentTransaction fragmentTransaction = this.currentTransaction;
                if (fragmentTransaction == null) break;
                FragmentTransactionExtensionsKt.detach(fragmentTransaction, disabledFragment);
                break;
            }
        }
        this.commitAllowingStateLoss();
    }

    private final void setCustomAnimations(@AnimatorRes @AnimRes int enter, @AnimatorRes @AnimRes int exit) {
        block0: {
            FragmentTransaction fragmentTransaction = this.currentTransaction;
            if (fragmentTransaction == null) break block0;
            fragmentTransaction.setCustomAnimations(enter, exit);
        }
    }

    private final Fragment getFragmentWithExecutingPendingTransactionsIfNeeded(String fragmentTag) {
        Fragment fragment = this.getFragment(fragmentTag);
        if (fragment == null && this.fragmentManager.executePendingTransactions()) {
            fragment = this.getFragment(fragmentTag);
        }
        return fragment;
    }

    @Nullable
    public final Fragment getFragment(@NotNull String fragmentTag) {
        Intrinsics.checkNotNullParameter((Object)fragmentTag, (String)"fragmentTag");
        return this.fragmentManager.findFragmentByTag(fragmentTag);
    }

    private final NavigatorTransaction getFragmentNavigatorTransaction(String fragmentTag) {
        NavigatorTransaction navigatorTransaction;
        block1: {
            navigatorTransaction = null;
            navigatorTransaction = this.navigatorTransaction;
            Fragment fragment = this.getFragment(fragmentTag);
            if (fragment == null) break block1;
            Fragment it = fragment;
            boolean bl = false;
            if (it instanceof Navigator.OnNavigatorTransactionListener) {
                navigatorTransaction = ((Navigator.OnNavigatorTransactionListener)it).getNavigatorTransaction();
            }
        }
        return navigatorTransaction;
    }

    public final void findFragmentByTagAndRemove(@NotNull String fragmentTag) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)fragmentTag, (String)"fragmentTag");
            this.checkAndCreateTransaction();
            Fragment fragment = this.getFragmentWithExecutingPendingTransactionsIfNeeded(fragmentTag);
            if (fragment == null) break block1;
            Fragment it = fragment;
            boolean bl = false;
            FragmentTransaction fragmentTransaction = this.currentTransaction;
            if (fragmentTransaction != null) {
                fragmentTransaction.remove(it);
            }
        }
    }

    private final void commitShow(String fragmentTag) {
        this.checkAndCreateTransaction();
        FragmentTransaction fragmentTransaction = this.currentTransaction;
        if (fragmentTransaction != null) {
            FragmentTransactionExtensionsKt.show(fragmentTransaction, this.getFragment(fragmentTag));
        }
        this.commitAllowingStateLoss();
    }

    private final void commitAttach(String fragmentTag) {
        this.checkAndCreateTransaction();
        FragmentTransaction fragmentTransaction = this.currentTransaction;
        if (fragmentTransaction != null) {
            FragmentTransactionExtensionsKt.attach(fragmentTransaction, this.getFragment(fragmentTag));
        }
        this.commitAllowingStateLoss();
    }

    private final void commitHide(String fragmentTag) {
        this.checkAndCreateTransaction();
        FragmentTransaction fragmentTransaction = this.currentTransaction;
        if (fragmentTransaction != null) {
            FragmentTransactionExtensionsKt.hide(fragmentTransaction, this.getFragmentWithExecutingPendingTransactionsIfNeeded(fragmentTag));
        }
        this.commitAllowingStateLoss();
    }

    private final void commitDetach(String fragmentTag) {
        this.checkAndCreateTransaction();
        FragmentTransaction fragmentTransaction = this.currentTransaction;
        if (fragmentTransaction != null) {
            FragmentTransactionExtensionsKt.detach(fragmentTransaction, this.getFragmentWithExecutingPendingTransactionsIfNeeded(fragmentTag));
        }
        this.commitAllowingStateLoss();
    }

    public final void commitAllowingStateLoss() {
        FragmentTransaction fragmentTransaction = this.currentTransaction;
        if (fragmentTransaction != null) {
            fragmentTransaction.commitAllowingStateLoss();
        }
        this.currentTransaction = null;
    }

    private final void checkAndCreateTransaction() {
        if (this.currentTransaction == null) {
            this.currentTransaction = this.fragmentManager.beginTransaction();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TransactionType.values().length];
            try {
                nArray[TransactionType.SHOW_HIDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionType.ATTACH_DETACH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TransitionAnimationType.values().length];
            try {
                nArray[TransitionAnimationType.LEFT_TO_RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransitionAnimationType.RIGHT_TO_LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransitionAnimationType.BOTTOM_TO_TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransitionAnimationType.TOP_TO_BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransitionAnimationType.FADE_IN_OUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

