/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.configuration;

import com.tridion.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableResolverUtil {
    private static final Logger LOG = LoggerFactory.getLogger(VariableResolverUtil.class);
    private static final int VARIABLE_BEGIN_INDEX = 2;
    private static final int VARIABLE_END_TRIM = 1;
    private static final String HIDDEN_MODIFIER = "*HIDDEN*";

    public static String resolveValue(String value) {
        String variable;
        if (StringUtils.isNotEmpty(value) && value.startsWith("${") && value.endsWith("}") && StringUtils.isNotEmpty(variable = value.substring(2, value.length() - 1))) {
            String resolvedValue;
            String[] parts = variable.split(":-");
            boolean isHidden = false;
            for (String part : parts) {
                if (!part.equals(HIDDEN_MODIFIER)) continue;
                isHidden = true;
                break;
            }
            if ((resolvedValue = System.getenv(parts[0])) == null && (resolvedValue = System.getProperty(parts[0])) == null) {
                resolvedValue = parts.length > 1 && parts[1] != null && !parts[1].equals(HIDDEN_MODIFIER) ? parts[1] : value;
            }
            LOG.debug("Found parameter: {}. Resolved value: {}", (Object)value, (Object)(isHidden ? "<hidden>" : resolvedValue));
            return resolvedValue;
        }
        return value;
    }
}

