/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.crypto;

import com.tridion.crypto.KeyProvider;
import com.tridion.crypto.SimpleKeyProvider;
import com.tridion.util.SecurityPolicyUtil;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;

public final class Crypto {
    private static final String ENCRYPTED_PREFIX = "encrypted:";
    private final KeyProvider keyProvider;

    public Crypto() {
        this.keyProvider = new SimpleKeyProvider();
    }

    public Crypto(KeyProvider keyProvider) {
        this.keyProvider = keyProvider;
    }

    public String encrypt(String secret) throws GeneralSecurityException {
        byte[] encrypted = this.cipher(secret.getBytes(), 1);
        return new String(Base64.getEncoder().encode(encrypted));
    }

    public String decrypt(String secret) throws GeneralSecurityException {
        byte[] decoded = Base64.getDecoder().decode(secret.getBytes());
        byte[] decrypted = this.cipher(decoded, 2);
        return new String(decrypted);
    }

    private byte[] cipher(byte[] secret, int mode) throws GeneralSecurityException {
        Key key = this.keyProvider.getKey();
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(mode, key);
        return cipher.doFinal(secret);
    }

    public static String decryptIfNecessary(String value) throws GeneralSecurityException {
        String toDecrypt;
        if (value != null && value.startsWith(ENCRYPTED_PREFIX) && (toDecrypt = value.substring(ENCRYPTED_PREFIX.length())).length() > 0) {
            return new Crypto().decrypt(toDecrypt);
        }
        return value;
    }

    static {
        SecurityPolicyUtil.enforcePackageAccessPolicy("com.tridion.crypto.");
    }
}

