/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Stack;

public final class ExceptionUtils {
    private static final String TRIDION_PACKAGE_NAME_START = "com.tridion";
    private static final String SEPARATOR = System.getProperty("line.SEPARATOR", "\n");

    private ExceptionUtils() {
    }

    public static String getMessageAndStackTrace(Throwable throwable) {
        String stackTrace = ExceptionUtils.getStackTrace(throwable);
        String message = throwable.getMessage();
        if (message == null) {
            return stackTrace;
        }
        return message + SEPARATOR + SEPARATOR + stackTrace;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        throwable.printStackTrace(printWriter);
        return writer.toString();
    }

    public static Throwable getAppropriateTridionCause(Throwable throwable) {
        Throwable cause;
        Stack<Throwable> throwableStack = new Stack<Throwable>();
        for (cause = throwable; cause != null; cause = cause.getCause()) {
            throwableStack.push(cause);
        }
        while (!throwableStack.empty()) {
            cause = (Throwable)throwableStack.pop();
            if (cause == null || !cause.getClass().getName().startsWith(TRIDION_PACKAGE_NAME_START)) continue;
            return cause;
        }
        return throwable;
    }
}

