/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util;

import java.io.File;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StringUtils.class);
    private static final String FILE_SEPARATOR;
    public static final String PATH_SEPARATOR;
    public static final String NEWLINE_CHARACTER;

    private StringUtils() {
    }

    public static int depthBelowCurrentPath(String basePath, String comparePath, String separator) {
        LOG.debug("Comparing basePath " + basePath + " to comparePath " + comparePath + " using separator " + separator);
        if (basePath.equals("") && comparePath.equals("")) {
            return 0;
        }
        if (!basePath.endsWith(separator)) {
            basePath = basePath + separator;
        }
        if (!comparePath.endsWith(separator)) {
            comparePath = comparePath + separator;
        }
        if (comparePath.length() < basePath.length()) {
            return -1;
        }
        if (comparePath.equalsIgnoreCase(basePath)) {
            return 0;
        }
        if (comparePath.length() == basePath.length()) {
            return -1;
        }
        if (!basePath.equalsIgnoreCase(comparePath.substring(0, basePath.length()))) {
            return -1;
        }
        String remainingPath = comparePath.substring(basePath.length());
        StringTokenizer tokens = new StringTokenizer(remainingPath, separator);
        LOG.debug("There are " + tokens.countTokens() + " subdirectories in remainingPath " + remainingPath);
        return tokens.countTokens();
    }

    public static String replace(String someString, String matchString, String replacement) {
        StringBuilder newString = new StringBuilder();
        int currentIndex = 0;
        int matchLength = matchString.length();
        int startIndex = someString.indexOf(matchString);
        while (true) {
            if (startIndex <= -1) break;
            newString.append(someString.substring(currentIndex, startIndex));
            newString.append(replacement);
            currentIndex = matchLength + startIndex;
            startIndex = someString.indexOf(matchString, currentIndex);
        }
        newString.append(someString.substring(currentIndex));
        return newString.toString();
    }

    public static String replace(String someString, char matchChar, String replacement) {
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < someString.length(); ++i) {
            if (someString.charAt(i) == matchChar) {
                newString.append(replacement);
                continue;
            }
            newString.append(someString.charAt(i));
        }
        return newString.toString();
    }

    public static String joinHostStringAndPath(String hostString, String path) {
        boolean hostEndsInSlash = true;
        if (hostString != null) {
            if (!hostString.endsWith("/")) {
                hostEndsInSlash = false;
            }
        } else {
            hostEndsInSlash = false;
            hostString = "";
        }
        boolean pathStartsWithSlash = true;
        if (path != null) {
            if (!path.startsWith("/")) {
                pathStartsWithSlash = false;
            }
        } else {
            pathStartsWithSlash = false;
            path = "";
        }
        String result = hostEndsInSlash && pathStartsWithSlash ? (path.length() > 1 ? hostString + path.substring(1) : hostString) : (!hostEndsInSlash && !pathStartsWithSlash ? hostString + "/" + path : hostString + path);
        return result;
    }

    public static String getFullURLString(String protocol, String domain, int port, String path) {
        boolean hasProtocol;
        int httpPort = 80;
        if (domain == null && path == null) {
            return null;
        }
        if ("".equals(protocol)) {
            protocol = null;
        }
        boolean bl = hasProtocol = protocol != null;
        if (!hasProtocol && domain != null) {
            protocol = "http";
            hasProtocol = true;
        }
        boolean addPort = true;
        boolean isHTTP = true;
        if (hasProtocol && !protocol.startsWith("http")) {
            isHTTP = false;
            if ("file".equals(protocol)) {
                addPort = false;
                if (domain == null) {
                    path = StringUtils.modifyPathForNullFileDomain(path);
                } else if (!domain.startsWith("/")) {
                    domain = "/" + domain;
                }
            }
        }
        if (isHTTP && port == 80) {
            addPort = false;
        }
        StringBuilder builder = new StringBuilder();
        if (hasProtocol) {
            builder.append(protocol);
            builder.append("://");
        }
        if (domain != null) {
            builder.append(domain);
        }
        if (hasProtocol && addPort) {
            builder.append(":");
            builder.append(port);
        }
        return StringUtils.joinHostStringAndPath(builder.toString(), path);
    }

    private static String modifyPathForNullFileDomain(String path) {
        if (path.length() < 2) {
            path = "/".equals(path) ? "//" : "//" + path;
        }
        if (!"//".equals(path.substring(0, 2))) {
            path = path.startsWith("/") ? "/" + path : "//" + path;
        }
        return path;
    }

    public static String joinMetaPaths(String dataPath, String metaPath, String urlPath) {
        StringBuilder fullPath = new StringBuilder();
        fullPath.append(dataPath);
        if (dataPath == null || !dataPath.endsWith(FILE_SEPARATOR)) {
            fullPath.append(FILE_SEPARATOR);
        }
        fullPath.append(metaPath);
        if (urlPath == null || !urlPath.startsWith(FILE_SEPARATOR) || !urlPath.startsWith("/")) {
            fullPath.append(FILE_SEPARATOR);
        }
        fullPath.append(urlPath);
        return fullPath.toString();
    }

    public static String normalizeString(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String ... strings) {
        if (strings == null) {
            return false;
        }
        for (String string : strings) {
            if (!StringUtils.isEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean stringEquals(String str1, String str2) {
        return Objects.isNull(str1) ? Objects.isNull(str2) : str1.equals(str2);
    }

    public static boolean stringEqualsIgnoreCase(String str1, String str2) {
        return Objects.isNull(str1) ? Objects.isNull(str2) : str1.equalsIgnoreCase(str2);
    }

    public static String trimIfNotNull(String string) {
        if (StringUtils.isNotEmpty(string)) {
            return string.trim();
        }
        return null;
    }

    public static boolean stringArrayContains(String[] array, String contains, boolean caseSensitive) {
        for (String arrayItem : array) {
            if (!arrayItem.equals(contains) && (caseSensitive || !arrayItem.equalsIgnoreCase(contains))) continue;
            return true;
        }
        return false;
    }

    public static String safeSubstring(String source, int beginIndex) throws ParseException {
        return StringUtils.safeSubstring(source, beginIndex, source.length());
    }

    public static String safeSubstring(String source, int beginIndex, int endIndex) throws ParseException {
        if (source == null || beginIndex < 0 || endIndex > source.length() || beginIndex > endIndex) {
            throw new ParseException("Internal exception while processing content!", 0);
        }
        return source.substring(beginIndex, endIndex);
    }

    public static String removeCharAt(String s, int pos) {
        return s.substring(0, pos) + s.substring(pos + 1);
    }

    public static String removeQuotations(String s) {
        if (s != null && !StringUtils.isEmpty(s)) {
            if (s.charAt(0) == '\'') {
                s = StringUtils.removeCharAt(s, 0);
            }
            if (s.charAt(s.length() - 1) == '\'') {
                s = StringUtils.removeCharAt(s, s.length() - 1);
            }
        }
        return s;
    }

    public static String addQuotations(String s) {
        if (s != null && !StringUtils.isEmpty(s)) {
            if (s.charAt(0) != '\'') {
                s = "'" + s;
            }
            if (s.charAt(s.length() - 1) != '\'') {
                s = s + "'";
            }
        }
        return s;
    }

    public static Long parseLong(String s) {
        if (s.endsWith("L") || s.endsWith("l")) {
            s = s.substring(0, s.length() - 1);
        }
        return Long.parseLong(s);
    }

    public static Set<String> splitString(String input, String delimiter) {
        return StringUtils.isEmpty(input) ? new HashSet<String>() : Stream.of(input.split(delimiter)).map(String::trim).collect(Collectors.toSet());
    }

    static {
        PATH_SEPARATOR = FILE_SEPARATOR = File.separator;
        NEWLINE_CHARACTER = System.getProperty("line.separator");
    }
}

