/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class LockManager<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LockManager.class);
    private final Map<T, Long> objectLocks = new HashMap<T, Long>();
    private final Lock lock = new ReentrantLock();
    private final Condition lockReleased = this.lock.newCondition();
    private final Random random = new Random(Thread.currentThread().getId());

    protected LockManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long lock(T object) {
        if (object != null) {
            long lockCookie = this.random.nextLong();
            this.lock.lock();
            try {
                while (this.objectLocks.containsKey(object)) {
                    LOG.debug("{} already locked, awaiting signal.", object);
                    this.lockReleased.await();
                }
                this.objectLocks.put(object, lockCookie);
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted while awaiting signal.", (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
            return lockCookie;
        }
        throw new IllegalArgumentException("Passed in a null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock(T object, long lockCookie) {
        block5: {
            if (object != null) {
                this.lock.lock();
                try {
                    if (this.objectLocks.containsKey(object) && this.objectLocks.get(object) == lockCookie) {
                        this.objectLocks.remove(object);
                        this.lockReleased.signal();
                        break block5;
                    }
                    throw new SecurityException("Invalid lock for: " + object);
                }
                finally {
                    this.lock.unlock();
                }
            }
            throw new IllegalArgumentException("Passed in a null.");
        }
    }
}

