/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimeUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final int TICKS = 60;
    private static final int MILLISECONDS = 1000;

    private TimeUtils() {
    }

    public static DateFormat getDateTimeFormatter() {
        SimpleDateFormat utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return utcFormatter;
    }

    public static long convertTimeToMs(int value, String units) {
        long time = value;
        if ("s".equalsIgnoreCase(units) || "sec".equalsIgnoreCase(units) || "seconds".equalsIgnoreCase(units)) {
            time *= 1000L;
        } else if ("m".equalsIgnoreCase(units) || "min".equalsIgnoreCase(units) || "minutes".equalsIgnoreCase(units)) {
            time *= 60000L;
        } else if ("h".equalsIgnoreCase(units) || "hours".equalsIgnoreCase(units)) {
            time *= 3600000L;
        } else if (!"ms".equals(units)) {
            throw new IllegalArgumentException("Unknown time units: " + units);
        }
        return time;
    }

    public static long convertTimeToMs(String text) {
        Pattern pattern = Pattern.compile("\\s*(\\d+)\\s*(\\w+)\\s*");
        Matcher matcher = pattern.matcher(text);
        if (matcher.matches()) {
            try {
                String valueString = matcher.group(1);
                int value = Integer.parseInt(valueString);
                String units = matcher.group(2);
                return TimeUtils.convertTimeToMs(value, units);
            }
            catch (Exception e) {
                return -1L;
            }
        }
        return -1L;
    }

    public static String createInternalStringDate(String stringDate, String dateFormat) throws ParseException {
        return TimeUtils.createInternalStringDate(TimeUtils.parseDate(stringDate, dateFormat));
    }

    public static Date parseDate(String stringDate, String dateFormat) throws ParseException {
        return new SimpleDateFormat(dateFormat).parse(stringDate);
    }

    public static String createInternalStringDate(Date inputDate) {
        return new SimpleDateFormat(DATE_FORMAT).format(inputDate);
    }
}

