/*
 * Decompiled with CFR 0.152.
 */
package com.tridion.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZipUtils.class);
    private static final int DEFAULT_BYTE_ARRAY_SIZE = 1024;

    private ZipUtils() {
    }

    public static File createArchive(File source) throws IOException {
        String destination = source.isDirectory() ? source.getParentFile().getCanonicalPath() + File.separatorChar + source.getName() + ".zip" : source.getCanonicalPath() + ".zip";
        LOG.debug("Creating archive " + destination + " based on " + source.getCanonicalPath());
        return ZipUtils.createArchive(source, new File(destination));
    }

    public static File createArchive(String source) throws IOException {
        return ZipUtils.createArchive(new File(source));
    }

    public static File createArchive(File source, File destination) throws IOException {
        return ZipUtils.createArchive(source, destination, false);
    }

    public static File createArchive(String source, String destination) throws IOException {
        return ZipUtils.createArchive(new File(source), new File(destination));
    }

    public static synchronized File createArchive(File source, File destination, boolean overwrite) throws IOException {
        File newDestination = destination;
        if (newDestination.isDirectory()) {
            newDestination = new File(newDestination.getCanonicalPath() + File.separatorChar + source.getName() + ".zip");
        }
        if (!overwrite && newDestination.exists()) {
            return newDestination;
        }
        FileOutputStream fileStream = new FileOutputStream(newDestination);
        ZipOutputStream zipStream = new ZipOutputStream(fileStream);
        if (source.isDirectory()) {
            ZipUtils.addFolder(source, zipStream, source.getName());
        } else {
            ZipUtils.addFile(source, zipStream, "");
        }
        zipStream.close();
        return newDestination;
    }

    public static File createArchive(String source, String destination, boolean overwrite) throws IOException {
        return ZipUtils.createArchive(new File(source), new File(destination), overwrite);
    }

    public static void unzip(File source, File destination) throws IOException {
        destination.mkdirs();
        if (!destination.isDirectory()) {
            throw new IOException("Destination for expanding an archive should be a directory!");
        }
        try (ZipFile zipFile = new ZipFile(source);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            byte[] buffer = new byte[1024];
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String outName = destination.getCanonicalPath() + File.separatorChar + entry.getName();
                File outFile = new File(outName);
                if (entry.isDirectory()) {
                    outFile.mkdirs();
                } else {
                    outFile.getParentFile().mkdirs();
                    try (FileOutputStream outStream = new FileOutputStream(outFile);
                         InputStream inStream = zipFile.getInputStream(entry);){
                        int total = 0;
                        while ((long)total < entry.getSize()) {
                            int read = inStream.read(buffer);
                            outStream.write(buffer, 0, read);
                            total += read;
                        }
                    }
                }
                LOG.debug("Uncompressed " + outName);
            }
        }
    }

    private static void addFolder(File source, ZipOutputStream archive, String prefix) throws IOException {
        File[] items;
        for (File item : items = source.listFiles()) {
            if (item.isDirectory()) {
                ZipUtils.addFolder(item, archive, prefix + "/" + item.getName());
                continue;
            }
            ZipUtils.addFile(item, archive, prefix);
        }
    }

    private static void addFile(File source, ZipOutputStream archive, String prefix) throws IOException {
        FileInputStream inStream = new FileInputStream(source);
        byte[] buffer = new byte[1024];
        LOG.debug("Adding " + prefix + "/" + source.getName());
        archive.putNextEntry(new ZipEntry(prefix + "/" + source.getName()));
        while (inStream.available() > 0) {
            archive.write(buffer, 0, inStream.read(buffer));
        }
        archive.closeEntry();
        inStream.close();
    }
}

