/*
 * Decompiled with CFR 0.152.
 */
package com.trigonic.jrobotx;

import com.trigonic.jrobotx.util.URLEncodeTokenizer;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Record {
    private Set<String> userAgents;
    private List<String[]> rules;

    public Record(Set<String> userAgents, List<String[]> rules) {
        this.userAgents = userAgents;
        this.rules = rules;
    }

    public Set<String> getUserAgents() {
        return Collections.unmodifiableSet(this.userAgents);
    }

    public List<String[]> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public boolean matches(String userAgentString) {
        boolean result = false;
        userAgentString = userAgentString.toLowerCase();
        for (String userAgent : this.userAgents) {
            if (!userAgent.equals("*") && !userAgentString.contains(userAgent)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean allows(String path) {
        boolean result = true;
        for (String[] rule : this.rules) {
            if (rule[1].length() <= 0 || !Record.ruleMatches(rule[1], path)) continue;
            result = rule[0].equals("Allow");
            break;
        }
        return result;
    }

    static boolean ruleMatches(String rule, String path) {
        boolean result = true;
        URLEncodeTokenizer ruleTokens = new URLEncodeTokenizer(rule, "/");
        URLEncodeTokenizer pathTokens = new URLEncodeTokenizer(path, "/");
        while (ruleTokens.hasNext() && pathTokens.hasNext()) {
            URLEncodeTokenizer.Token token2;
            URLEncodeTokenizer.Token token1 = (URLEncodeTokenizer.Token)ruleTokens.next();
            if (token1.equals(token2 = (URLEncodeTokenizer.Token)pathTokens.next())) continue;
            result = false;
            break;
        }
        if (result && ruleTokens.hasNext()) {
            result = false;
        }
        return result;
    }
}

