/*
 * Decompiled with CFR 0.152.
 */
package com.trigonic.jrobotx;

import com.trigonic.jrobotx.Record;
import com.trigonic.jrobotx.util.AbstractIterator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordIterator
extends AbstractIterator<Record> {
    private static final Logger LOG = Logger.getLogger(RecordIterator.class);
    private BufferedReader reader;
    private List<String> pushBack = new ArrayList<String>();
    private Record defaultRecord;
    private Set<String> unknownFields = new HashSet<String>();

    public RecordIterator(BufferedReader reader) {
        this.reader = reader;
    }

    public RecordIterator(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public RecordIterator(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public Record getDefaultRecord() {
        return this.defaultRecord;
    }

    public Set<String> getUnknownFields() {
        return this.unknownFields;
    }

    @Override
    protected Record getNext() {
        Record record = null;
        if (this.reader != null) {
            try {
                String line;
                HashSet<String> userAgents = new HashSet<String>();
                ArrayList<String[]> rules = new ArrayList<String[]>();
                boolean inUserAgents = true;
                while ((line = this.readLine()) != null) {
                    String[] pieces = this.splitLine(line);
                    if (pieces[0].equals("")) continue;
                    if (pieces[0].equals("User-agent")) {
                        if (inUserAgents) {
                            userAgents.add(pieces[1]);
                            continue;
                        }
                        this.pushBack.add(0, line);
                        break;
                    }
                    if (pieces[0].equals("Allow") || pieces[0].equals("Disallow")) {
                        inUserAgents = false;
                        rules.add(pieces);
                        continue;
                    }
                    if (pieces[0].equals("Sitemap")) continue;
                    this.unknownFields.add(pieces[0]);
                }
                if (line == null) {
                    IOUtils.closeQuietly((Reader)this.reader);
                    this.reader = null;
                }
                if (userAgents.size() > 0 || rules.size() > 0) {
                    record = new Record(userAgents, rules);
                }
            }
            catch (IOException e) {
                LOG.info((Object)"read failed", (Throwable)e);
            }
            if (record != null && record.matches("*")) {
                this.defaultRecord = record;
            }
        }
        return record;
    }

    private String readLine() throws IOException {
        String result = null;
        result = this.pushBack.size() > 0 ? this.pushBack.remove(0) : this.reader.readLine();
        return result;
    }

    private String[] splitLine(String line) {
        String[] results = new String[2];
        String[] pieces = line.trim().split("#", 2);
        pieces = pieces[0].split(":", 2);
        for (int i = 0; i < pieces.length; ++i) {
            results[i] = pieces[i].trim();
        }
        return results;
    }
}

