/*
 * Decompiled with CFR 0.152.
 */
package com.trigonic.jrobotx;

import com.trigonic.jrobotx.Record;
import com.trigonic.jrobotx.RecordIterator;
import com.trigonic.jrobotx.util.DefaultURLInputStreamFactory;
import com.trigonic.jrobotx.util.URLInputStreamFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class RobotExclusion {
    private static final Logger LOG = Logger.getLogger(RobotExclusion.class);
    private static final Set<String> SUPPORTED_PROTOCOLS = new HashSet<String>(Arrays.asList("http", "https"));
    private URLInputStreamFactory urlInputStreamFactory;

    public RobotExclusion(URLInputStreamFactory urlInputStreamFactory) {
        this.urlInputStreamFactory = urlInputStreamFactory;
    }

    public RobotExclusion() {
        this(new DefaultURLInputStreamFactory());
    }

    public RecordIterator get(URL url) {
        RecordIterator recordIter = null;
        if (!SUPPORTED_PROTOCOLS.contains(url.getProtocol().toLowerCase())) {
            return null;
        }
        try {
            URL robotsUrl = new URL(url, "/robots.txt");
            recordIter = new RecordIterator(this.urlInputStreamFactory.openStream(robotsUrl));
        }
        catch (IOException e) {
            LOG.info((Object)("Failed to fetch " + url), (Throwable)e);
        }
        return recordIter;
    }

    public Record get(URL url, String userAgentString) {
        Record result = null;
        RecordIterator recordIter = this.get(url);
        if (recordIter != null) {
            while (recordIter.hasNext()) {
                Record record = (Record)recordIter.next();
                if (!record.matches(userAgentString)) continue;
                result = record;
                break;
            }
            if (result == null) {
                result = recordIter.getDefaultRecord();
            }
        }
        return result;
    }

    public boolean allows(URL url, String userAgentString) {
        if (Record.ruleMatches("/robots.txt", url.getFile())) {
            return true;
        }
        Record record = this.get(url, userAgentString);
        return record == null || record.allows(url.getPath());
    }
}

