/*
 * Decompiled with CFR 0.152.
 */
package com.trigonic.jrobotx.util;

import com.trigonic.jrobotx.util.AbstractIterator;
import com.trigonic.jrobotx.util.CompareUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLEncodeTokenizer
extends AbstractIterator<Token> {
    private String string;
    private String specialChars;
    private int pos;

    public URLEncodeTokenizer(String urlEncodedString, String specialChars) {
        this.string = urlEncodedString;
        this.specialChars = specialChars;
    }

    @Override
    protected Token getNext() {
        Token result = null;
        if (this.pos < this.string.length()) {
            char ch = this.string.charAt(this.pos++);
            boolean special = false;
            if (ch == '%' && URLEncodeTokenizer.isHexDigits(this.string, this.pos, 2)) {
                ch = (char)Integer.parseInt(this.string.substring(this.pos, this.pos + 2), 16);
                this.pos += 2;
            } else if (this.specialChars.indexOf(ch) >= 0) {
                special = true;
            }
            result = new Token(ch, special);
        }
        return result;
    }

    private static boolean isHexDigits(String str, int pos, int length) {
        boolean result = false;
        if (pos + length - 1 < str.length()) {
            for (int i = 0; i < length && (result = URLEncodeTokenizer.isHexDigit(str.charAt(pos + i))); ++i) {
            }
        }
        return result;
    }

    private static boolean isHexDigit(char ch) {
        return Character.isDigit(ch) || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Token
    implements Comparable<Token> {
        private char ch;
        private boolean special;

        public Token(char ch, boolean special) {
            this.ch = ch;
            this.special = special;
        }

        public char getCharacter() {
            return this.ch;
        }

        public boolean isSpecial() {
            return this.special;
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj != null && obj instanceof Token) {
                Token other = (Token)obj;
                result = this.ch == other.ch && this.special == other.special;
            }
            return result;
        }

        @Override
        public int compareTo(Token other) {
            int result = CompareUtils.compare(this.ch, other.ch);
            if (result == 0) {
                result = CompareUtils.compare(this.special, other.special);
            }
            return result;
        }
    }
}

