/*
 * Decompiled with CFR 0.152.
 */
package com.trinetix.webrobo.core.data;

import com.trinetix.webrobo.core.data.DatabaseHelper;
import java.util.concurrent.ConcurrentHashMap;

public class DatabaseFactory {
    private ConcurrentHashMap<String, DatabaseHelper> mHelpers = new ConcurrentHashMap();
    private static volatile DatabaseFactory sFactory;

    public static synchronized DatabaseFactory getFactory() {
        if (sFactory == null) {
            sFactory = new DatabaseFactory();
        }
        return sFactory;
    }

    public synchronized DatabaseHelper getHelper(String key) {
        return this.mHelpers.get(key);
    }

    public void putHelper(String key, DatabaseHelper helper) {
        this.mHelpers.put(key, helper);
    }

    public synchronized void releaseHelpers() {
        for (DatabaseHelper helper : this.mHelpers.values()) {
            helper.releaseHelper();
            helper.close();
        }
    }
}

