/*
 * Decompiled with CFR 0.152.
 */
package com.trinetix.webrobo.core.data;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.j256.ormlite.android.apptools.OpenHelperManager;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import com.octo.android.robospice.persistence.ormlite.RoboSpiceDatabaseHelper;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.sql.SQLException;
import roboguice.util.temp.Ln;

public abstract class DatabaseHelper
extends RoboSpiceDatabaseHelper {
    private static final String TAG = "DatabaseHelper";

    public DatabaseHelper(Context context, SQLiteDatabase.CursorFactory cursorFactory, String dataBaseName, int version) {
        super(context, dataBaseName, cursorFactory, version);
    }

    public abstract void initHelper(Context var1);

    public synchronized void releaseHelper() {
        OpenHelperManager.releaseHelper();
    }

    @TargetApi(value=14)
    public void onCreate(SQLiteDatabase sqLiteDatabase, ConnectionSource connectionSource) {
        try {
            this.create(connectionSource);
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)("error creating DB " + this.getDatabaseName()));
            throw new RuntimeException(e);
        }
    }

    public void onUpgrade(SQLiteDatabase sqLiteDatabase, ConnectionSource connectionSource, int oldVer, int newVer) {
        this.upgrade(sqLiteDatabase, connectionSource, oldVer, newVer);
    }

    public abstract void upgrade(SQLiteDatabase var1, ConnectionSource var2, int var3, int var4);

    protected abstract void create(ConnectionSource var1) throws SQLException;

    public Dao getDao(Class clazz) {
        try {
            return DaoManager.createDao((ConnectionSource)this.getConnectionSource(), (Class)clazz);
        }
        catch (SQLException e) {
            Log.e((String)TAG, (String)e.getMessage());
            return null;
        }
    }

    public <T> void clearTableFromDataBase(Class<T> modelObjectClass) throws SQLException {
        try {
            this.myClearTable(modelObjectClass);
        }
        catch (Exception ex) {
            Ln.d((Throwable)ex, (Object)"An exception occurred when cleaning table", (Object[])new Object[0]);
        }
    }

    private <T> void myClearTable(Class<T> clazz) throws SQLException {
        for (Field field : clazz.getDeclaredFields()) {
            ForeignCollectionField annotation = field.getAnnotation(ForeignCollectionField.class);
            if (annotation == null) continue;
            ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
            Class itemInListClass = (Class)stringListType.getActualTypeArguments()[0];
            this.myClearTable(itemInListClass);
        }
        TableUtils.clearTable((ConnectionSource)this.getConnectionSource(), clazz);
    }
}

