/*
 * Decompiled with CFR 0.152.
 */
package com.trinetix.webrobo.core.persister;

import android.app.Application;
import android.net.Uri;
import com.j256.ormlite.dao.LazyForeignCollection;
import com.j256.ormlite.dao.RuntimeExceptionDao;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.ForeignCollectionField;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableUtils;
import com.octo.android.robospice.persistence.ObjectPersister;
import com.octo.android.robospice.persistence.exception.CacheLoadingException;
import com.octo.android.robospice.persistence.exception.CacheSavingException;
import com.octo.android.robospice.persistence.ormlite.CacheEntry;
import com.trinetix.webrobo.core.data.DatabaseHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import roboguice.util.temp.Ln;

public class BaseObjectPersister<T, ID>
extends ObjectPersister<T> {
    private DatabaseHelper databaseHelper;
    private RuntimeExceptionDao<T, ID> dao;
    private Uri notificationUri;
    private final String RESULT_CLASS_NAME_FIELD_NAME = "resultClassName";

    public BaseObjectPersister(Application application, DatabaseHelper databaseHelper, Class<T> modelObjectType) {
        this(application, databaseHelper, modelObjectType, null);
    }

    public BaseObjectPersister(Application application, DatabaseHelper databaseHelper, Class<T> modelObjectType, Uri notificationUri) {
        super(application, modelObjectType);
        this.databaseHelper = databaseHelper;
        this.notificationUri = notificationUri;
        try {
            TableUtils.createTableIfNotExists((ConnectionSource)databaseHelper.getConnectionSource(), modelObjectType);
        }
        catch (SQLException e1) {
            Ln.e((Throwable)e1, (Object)("SQL Error while creating table for " + modelObjectType), (Object[])new Object[0]);
        }
        try {
            this.dao = databaseHelper.getRuntimeExceptionDao(modelObjectType);
        }
        catch (Throwable e) {
            Ln.e((Throwable)e, (Object)"SQL Error", (Object[])new Object[0]);
        }
    }

    public T loadDataFromCache(Object cacheKey, long maxTimeInCache) throws CacheLoadingException {
        Object result = null;
        try {
            CacheEntry cacheEntry = this.databaseHelper.queryCacheKeyForIdFromDatabase(String.valueOf(cacheKey));
            if (cacheEntry == null) {
                return null;
            }
            Object id = cacheEntry.getResultId();
            long timeInCache = System.currentTimeMillis() - cacheEntry.getTimestamp();
            if (maxTimeInCache == 0L || timeInCache <= maxTimeInCache) {
                result = this.databaseHelper.queryForIdFromDatabase(id, this.getHandledClass());
            }
        }
        catch (SQLException e) {
            Ln.e((Throwable)e, (Object)"SQL error", (Object[])new Object[0]);
        }
        return (T)result;
    }

    public T saveDataToCacheAndReturnData(final T data, final Object cacheKey) throws CacheSavingException {
        try {
            this.dao.callBatchTasks((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        BaseObjectPersister.this.databaseHelper.createOrUpdateInDatabase(data, BaseObjectPersister.this.getHandledClass());
                        BaseObjectPersister.this.saveAllForeignObjectsToCache(data);
                        Object id = null;
                        DatabaseTableConfig childDatabaseTableConfig = DatabaseTableConfig.fromClass((ConnectionSource)BaseObjectPersister.this.databaseHelper.getConnectionSource(), data.getClass());
                        for (FieldType childFieldType : childDatabaseTableConfig.getFieldTypes(null)) {
                            if (!childFieldType.isId()) continue;
                            id = childFieldType.extractJavaFieldValue(data);
                        }
                        CacheEntry cacheEntry = new CacheEntry(String.valueOf(cacheKey), System.currentTimeMillis(), data.getClass(), id);
                        BaseObjectPersister.this.databaseHelper.createOrUpdateCacheEntryInDatabase(cacheEntry);
                        if (BaseObjectPersister.this.notificationUri != null) {
                            BaseObjectPersister.this.getApplication().getContentResolver().notifyChange(BaseObjectPersister.this.notificationUri, null);
                            Uri itemNotificationUri = BaseObjectPersister.this.notificationUri.buildUpon().appendPath(id.toString()).build();
                            BaseObjectPersister.this.getApplication().getContentResolver().notifyChange(itemNotificationUri, null);
                        }
                    }
                    catch (Exception e) {
                        Ln.d((Throwable)e, (Object)"Exception occured during saveDataToCacheAndReturnData", (Object[])new Object[0]);
                    }
                    return null;
                }
            });
            this.databaseHelper.refreshFromDatabase(data, this.getHandledClass());
            return data;
        }
        catch (Exception e) {
            Ln.e((Throwable)e, (Object)"SQL Error", (Object[])new Object[0]);
            return null;
        }
    }

    public boolean isDataInCache(Object cacheKey, long maxTimeInCache) {
        try {
            CacheEntry cacheEntry = this.databaseHelper.queryCacheKeyForIdFromDatabase(String.valueOf(cacheKey));
            if (cacheEntry == null) {
                return false;
            }
            long timeInCache = System.currentTimeMillis() - cacheEntry.getTimestamp();
            return maxTimeInCache == 0L || timeInCache <= maxTimeInCache;
        }
        catch (SQLException e) {
            Ln.e((Throwable)e, (Object)"SQL error", (Object[])new Object[0]);
            return false;
        }
    }

    public long getCreationDateInCache(Object cacheKey) throws CacheLoadingException {
        CacheEntry cacheEntry = null;
        try {
            cacheEntry = this.databaseHelper.queryCacheKeyForIdFromDatabase(String.valueOf(cacheKey));
        }
        catch (SQLException e) {
            throw new CacheLoadingException("Data could not be found in cache for cacheKey=" + cacheKey, (Throwable)e);
        }
        if (cacheEntry == null) {
            throw new CacheLoadingException("Data could not be found in cache for cacheKey=" + cacheKey);
        }
        return cacheEntry.getTimestamp();
    }

    protected <E> void saveAllForeignObjectsToCache(E data) throws SQLException, IllegalAccessException, InvocationTargetException {
        HashMap mapFieldToCollection = new HashMap();
        Class<?> parentClass = data.getClass();
        for (Field field : parentClass.getDeclaredFields()) {
            ForeignCollectionField annotation = field.getAnnotation(ForeignCollectionField.class);
            if (annotation == null) continue;
            ArrayList collectionCopy = new ArrayList();
            Method getMethod = DatabaseFieldConfig.findGetMethod((Field)field, (boolean)true);
            Collection collectionInObject = (Collection)getMethod.invoke(data, new Object[0]);
            if (collectionInObject != null) {
                collectionCopy.addAll(collectionInObject);
            }
            Method setMethod = DatabaseFieldConfig.findSetMethod((Field)field, (boolean)true);
            setMethod.invoke(data, new Object[]{null});
            mapFieldToCollection.put(field, collectionCopy);
        }
        this.databaseHelper.createOrUpdateInDatabase(data, parentClass);
        this.databaseHelper.refreshFromDatabase(data, parentClass);
        for (Field field : parentClass.getDeclaredFields()) {
            if (field.getAnnotation(ForeignCollectionField.class) == null) continue;
            Method getMethod = DatabaseFieldConfig.findGetMethod((Field)field, (boolean)true);
            Collection collectionInObject = (Collection)getMethod.invoke(data, new Object[0]);
            if (collectionInObject instanceof LazyForeignCollection) {
                ((LazyForeignCollection)collectionInObject).refreshCollection();
            }
            ParameterizedType listType = (ParameterizedType)field.getGenericType();
            Class itemInListClass = (Class)listType.getActualTypeArguments()[0];
            this.databaseHelper.deleteFromDataBase(collectionInObject, itemInListClass);
        }
        for (Map.Entry entry : mapFieldToCollection.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            ConnectionSource connectionSource = this.databaseHelper.getConnectionSource();
            for (Object object : collection) {
                DatabaseTableConfig childDatabaseTableConfig = DatabaseTableConfig.fromClass((ConnectionSource)connectionSource, object.getClass());
                for (FieldType childFieldType : childDatabaseTableConfig.getFieldTypes(null)) {
                    if (!parentClass.equals(childFieldType.getType()) || !childFieldType.isForeign()) continue;
                    childFieldType.assignField(object, data, true, null);
                }
                this.saveAllForeignObjectsToCache(object);
            }
        }
    }

    public boolean removeDataFromCache(Object cacheKey) {
        try {
            String id = cacheKey.toString();
            CacheEntry cacheEntry = this.databaseHelper.queryCacheKeyForIdFromDatabase(id);
            if (cacheEntry == null) {
                return false;
            }
            Class<?> clazz = Class.forName(cacheEntry.getResultClassName());
            this.databaseHelper.deleteByIdFromDataBase(cacheEntry.getResultId(), clazz);
            this.databaseHelper.deleteFromDataBase(cacheEntry, CacheEntry.class);
            return true;
        }
        catch (SQLException e) {
            Ln.d((Throwable)e);
            return false;
        }
        catch (ClassNotFoundException e) {
            Ln.d((Throwable)e);
            return false;
        }
    }

    public void removeAllDataFromCache() {
        try {
            Class clazz = this.getHandledClass();
            this.databaseHelper.clearTableFromDataBase(clazz);
            DeleteBuilder deleteBuilder = this.databaseHelper.getDao(CacheEntry.class).deleteBuilder();
            deleteBuilder.where().eq("resultClassName", (Object)clazz.getCanonicalName());
            deleteBuilder.delete();
        }
        catch (SQLException e) {
            Ln.d((Throwable)e, (Object)"SQL Error", (Object[])new Object[0]);
        }
    }

    public List<T> loadAllDataFromCache() throws CacheLoadingException {
        try {
            List listCacheEntry = this.databaseHelper.queryForAllFromDatabase(CacheEntry.class);
            ArrayList<T> listObjectInCache = new ArrayList<T>();
            for (CacheEntry cacheEntry : listCacheEntry) {
                listObjectInCache.add(this.loadDataFromCache(cacheEntry.getCacheKey(), 0L));
            }
            return listObjectInCache;
        }
        catch (SQLException e) {
            Ln.d((Throwable)e);
            return null;
        }
    }

    public List<Object> getAllCacheKeys() {
        try {
            List listCacheEntry = this.databaseHelper.queryForAllFromDatabase(CacheEntry.class);
            ArrayList<Object> listCacheKey = new ArrayList<Object>();
            for (CacheEntry cacheEntry : listCacheEntry) {
                listCacheKey.add(cacheEntry.getCacheKey());
            }
            return listCacheKey;
        }
        catch (SQLException e) {
            return null;
        }
    }
}

