/*
 * Decompiled with CFR 0.152.
 */
package com.trinetix.webrobo.core.persister;

import android.app.Application;
import android.net.Uri;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import com.octo.android.robospice.persistence.ObjectPersister;
import com.octo.android.robospice.persistence.ObjectPersisterFactory;
import com.octo.android.robospice.persistence.ormlite.CacheEntry;
import com.trinetix.webrobo.core.data.DatabaseHelper;
import com.trinetix.webrobo.core.persister.BaseObjectPersister;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import roboguice.util.temp.Ln;

public class BaseObjectPersisterFactory
extends ObjectPersisterFactory {
    private DatabaseHelper databaseHelper;
    private boolean isAllTableCreated = false;
    private Map<Class<?>, Uri> mapHandledClassesToNotificationUri;

    public BaseObjectPersisterFactory(Application application, DatabaseHelper databaseHelper, Map<Class<?>, Uri> mapHandledClassesToNotificationUri) {
        super(application, new ArrayList(mapHandledClassesToNotificationUri.keySet()));
        this.databaseHelper = databaseHelper;
        this.mapHandledClassesToNotificationUri = mapHandledClassesToNotificationUri;
    }

    public BaseObjectPersisterFactory(Application application, DatabaseHelper databaseHelper, List<Class<?>> listHandledClasses) {
        super(application, listHandledClasses);
        this.databaseHelper = databaseHelper;
    }

    public <DATA> ObjectPersister<DATA> createObjectPersister(Class<DATA> clazz) {
        this.initializeTablesIfNeeded();
        if (this.mapHandledClassesToNotificationUri != null && this.mapHandledClassesToNotificationUri.containsKey(clazz)) {
            Uri notificationUri = this.mapHandledClassesToNotificationUri.get(clazz);
            return new BaseObjectPersister(this.getApplication(), this.databaseHelper, clazz, notificationUri);
        }
        return new BaseObjectPersister(this.getApplication(), this.databaseHelper, clazz);
    }

    private void createTableIfNotExists(Class<?> clazz) {
        try {
            TableUtils.createTableIfNotExists((ConnectionSource)this.databaseHelper.getConnectionSource(), clazz);
        }
        catch (SQLException e) {
            Ln.e((Throwable)e, (Object)"RoboSpice", (Object[])new Object[]{"Could not create cache entry table"});
        }
    }

    private void initializeTablesIfNeeded() {
        if (!this.isAllTableCreated) {
            this.createTableIfNotExists(CacheEntry.class);
            if (this.getListHandledClasses() != null) {
                for (Class clazz : this.getListHandledClasses()) {
                    this.createTableIfNotExists(clazz);
                }
            }
            this.isAllTableCreated = true;
        }
    }
}

