/*
 * Decompiled with CFR 0.152.
 */
package com.trinetix.webrobo.exceptions;

import android.util.Log;
import com.octo.android.robospice.exception.NoNetworkException;
import com.trinetix.webrobo.exceptions.DeveloperErrorException;
import com.trinetix.webrobo.exceptions.ServerErrorException;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import retrofit.ErrorHandler;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class NetworkErrorHandler
implements ErrorHandler {
    private static final String TAG = NetworkErrorHandler.class.getSimpleName();

    public Throwable handleError(RetrofitError retrofitError) {
        int status;
        if (retrofitError.isNetworkError()) {
            Log.w((String)TAG, (String)("Cannot connect to " + retrofitError.getUrl()));
            return new NoNetworkException();
        }
        Response response = retrofitError.getResponse();
        if (response != null && (status = response.getStatus()) >= 300) {
            Log.w((String)TAG, (String)("Error " + String.valueOf(status) + " while accessing " + retrofitError.getUrl()));
            return retrofitError;
        }
        int index = ExceptionUtils.indexOfType((Throwable)retrofitError, ServerErrorException.class);
        if (index >= 0) {
            List errorList = ExceptionUtils.getThrowableList((Throwable)retrofitError);
            ServerErrorException serverErrorException = (ServerErrorException)errorList.get(index);
            if (serverErrorException instanceof DeveloperErrorException) {
                Log.e((String)TAG, (String)("Developer error with code" + serverErrorException.getErrorCode()), (Throwable)serverErrorException);
            }
            return serverErrorException;
        }
        return retrofitError;
    }
}

