/*
 * Decompiled with CFR 0.152.
 */
package com.trinetix.webrobo.policy;

import com.octo.android.robospice.persistence.exception.SpiceException;
import com.octo.android.robospice.retry.RetryPolicy;
import com.trinetix.webrobo.exceptions.ServerErrorException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class NetworkRetryPolicy
implements RetryPolicy {
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final long DEFAULT_DELAY_BEFORE_RETRY = 2500L;
    public static final float DEFAULT_BACKOFF_MULT = 1.0f;
    private int retryCount = 3;
    private long delayBeforeRetry = 2500L;
    private float backOffMultiplier = 1.0f;

    public NetworkRetryPolicy(int retryCount, long delayBeforeRetry, float backOffMultiplier) {
        this.retryCount = retryCount;
        this.delayBeforeRetry = delayBeforeRetry;
        this.backOffMultiplier = backOffMultiplier;
    }

    public NetworkRetryPolicy() {
        this(3, 2500L, 1.0f);
    }

    public void retry(SpiceException e) {
        this.retryCount = ExceptionUtils.indexOfType((Throwable)e, ServerErrorException.class) >= 0 ? 0 : --this.retryCount;
        this.delayBeforeRetry = (long)((float)this.delayBeforeRetry * this.backOffMultiplier);
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public long getDelayBeforeRetry() {
        return this.delayBeforeRetry;
    }
}

