/*
 * Decompiled with CFR 0.152.
 */
package com.trinetix.webrobo.request;

import com.trinetix.webrobo.request.BaseRequest;
import com.trinetix.webrobo.request.CustomRequestListener;

public class Request {
    private final BaseRequest request;
    private final long time;
    private final CustomRequestListener listener;

    private Request(BaseRequest request, long time, CustomRequestListener listener) {
        this.request = request;
        this.time = time;
        this.listener = listener;
    }

    public BaseRequest getRequest() {
        return this.request;
    }

    public long getTime() {
        return this.time;
    }

    public CustomRequestListener getListener() {
        return this.listener;
    }

    public static class RequestBuilder {
        private BaseRequest request;
        private long time;
        private CustomRequestListener listener;

        public RequestBuilder request(BaseRequest request) throws NullPointerException {
            this.request = request;
            if (null == this.request) {
                throw new NullPointerException("Request is null");
            }
            return this;
        }

        public RequestBuilder time(long time) {
            if (time == 0L) {
                time = -1L;
            }
            this.time = time;
            return this;
        }

        public RequestBuilder requestListener(CustomRequestListener listener) {
            if (null == listener) {
                throw new NullPointerException("Request listener");
            }
            this.listener = listener;
            return this;
        }

        public Request build() {
            if (null == this.request) {
                throw new NullPointerException("Request is null");
            }
            if (null == this.listener) {
                throw new NullPointerException("Listener is null");
            }
            return new Request(this.request, this.time, this.listener);
        }
    }
}

