/*
 * Decompiled with CFR 0.152.
 */
package com.trinetix.webrobo.retrofit;

import android.content.Context;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.internal.bind.DateTypeAdapter;
import com.squareup.okhttp.Cache;
import com.squareup.okhttp.OkHttpClient;
import com.trinetix.webrobo.exceptions.NetworkErrorHandler;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import retrofit.ErrorHandler;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.OkClient;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

public class RetrofitHelper {
    private static final String CACHE_DIR = "HttpCache";
    private static final String TAG = "RetrofitHelper";

    public static RestAdapter.Builder createApiRestAdapterBuilder(RestAdapter.Builder builder, Context context, Map<Class<?>, JsonDeserializer<?>> mapClassToDeserializer) {
        return RetrofitHelper.createBaseRestAdapterBuilderWithDeserializer(builder, context, mapClassToDeserializer).setErrorHandler((ErrorHandler)new NetworkErrorHandler());
    }

    public static RestAdapter.Builder createBaseRestAdapterBuilder(RestAdapter.Builder builder, Context context) {
        return RetrofitHelper.createBaseRestAdapterBuilderWithDeserializer(builder, context, null);
    }

    public static RestAdapter.Builder createBaseRestAdapterBuilderWithDeserializer(RestAdapter.Builder builder, Context context, Map<Class<?>, JsonDeserializer<?>> mapClassToDeserializer) {
        if (builder == null) {
            builder = new RestAdapter.Builder();
        }
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        if (mapClassToDeserializer != null) {
            for (Class<?> clazz : mapClassToDeserializer.keySet()) {
                gsonBuilder.registerTypeAdapter(clazz, mapClassToDeserializer.get(clazz));
            }
        }
        Gson gson = gsonBuilder.create();
        int cacheSize = 0xA00000;
        File cacheDirectory = new File(context.getCacheDir().getAbsolutePath(), CACHE_DIR);
        Cache cache = null;
        try {
            cache = new Cache(cacheDirectory, (long)cacheSize);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Can't create cache dir");
            e.printStackTrace();
        }
        OkHttpClient okHttpClient = new OkHttpClient();
        okHttpClient.setCache(cache);
        builder.setClient((Client)new OkClient(okHttpClient));
        builder.setConverter((Converter)new GsonConverter(gson)).build();
        builder.setLogLevel(RestAdapter.LogLevel.FULL);
        return builder.setErrorHandler((ErrorHandler)new NetworkErrorHandler());
    }
}

