/*
 * Decompiled with CFR 0.152.
 */
package com.trinetix.webrobo.service;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.octo.android.robospice.retrofit.RetrofitGsonSpiceService;
import java.util.HashMap;
import java.util.Map;
import retrofit.RestAdapter;

public abstract class BaseRetrofitWebService
extends RetrofitGsonSpiceService {
    protected Map<Class<?>, RestAdapter> mRetrofitInterfaceToRestAdapter;
    protected Map<Class<?>, Object> mRetrofitInterfaceToServiceMap = new HashMap();
    protected RestAdapter.Builder mDefaultRestAdapterBuilder;
    protected RestAdapter mDefaultRestAdapter;

    public void onCreate() {
        super.onCreate();
    }

    protected String getServerUrl() {
        return null;
    }

    @TargetApi(value=16)
    public Notification createDefaultNotification() {
        if (Build.VERSION.SDK_INT >= 18) {
            return null;
        }
        Notification notification = new Notification();
        notification.icon = this.getApplicationInfo().icon;
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.getApplicationContext(), (int)0, (Intent)new Intent(), (int)0);
        notification.setLatestEventInfo((Context)this, (CharSequence)"", (CharSequence)"", pendingIntent);
        if (Build.VERSION.SDK_INT > 16) {
            notification.priority = -2;
        }
        return notification;
    }

    protected RestAdapter.Builder createRestAdapterBuilder() {
        RestAdapter.Builder builder;
        this.mDefaultRestAdapterBuilder = builder = this.createDefaultRestAdapterBuilder();
        this.mDefaultRestAdapter = builder.build();
        return builder;
    }

    protected abstract RestAdapter.Builder createDefaultRestAdapterBuilder();

    protected void addRetrofitInterface(Class<?> serviceClass) {
        this.addRetrofitInterface(serviceClass, this.mDefaultRestAdapter);
    }

    protected void addRetrofitInterface(Class<?> serviceClass, RestAdapter restAdapter) {
        if (this.mRetrofitInterfaceToRestAdapter == null) {
            this.mRetrofitInterfaceToRestAdapter = new HashMap();
        }
        this.mRetrofitInterfaceToRestAdapter.put(serviceClass, restAdapter);
    }

    protected <T> T getRetrofitService(Class<T> serviceClass) {
        Object service = this.mRetrofitInterfaceToServiceMap.get(serviceClass);
        if (service == null) {
            service = this.createRetrofitService(serviceClass);
            this.mRetrofitInterfaceToServiceMap.put(serviceClass, service);
        }
        return (T)service;
    }

    protected <T> T createRetrofitService(Class<T> serviceClass) {
        if (this.mRetrofitInterfaceToRestAdapter != null && this.mRetrofitInterfaceToRestAdapter.containsKey(serviceClass)) {
            RestAdapter restAdapter = this.mRetrofitInterfaceToRestAdapter.get(serviceClass);
            return (T)restAdapter.create(serviceClass);
        }
        return (T)this.mDefaultRestAdapter.create(serviceClass);
    }
}

