/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.fastutilconcurrentwrapper;

import com.trivago.fastutilconcurrentwrapper.LongLongMap;
import com.trivago.fastutilconcurrentwrapper.map.ConcurrentBusyWaitingLongLongMap;
import com.trivago.fastutilconcurrentwrapper.map.ConcurrentLongLongMap;

public final class ConcurrentLongLongMapBuilder {
    private MapMode mapMode = MapMode.BLOCKING;
    private int buckets = 8;
    private int initialCapacity = 100000;
    private float loadFactor = 0.8f;
    private long defaultValue = 0L;

    private ConcurrentLongLongMapBuilder() {
    }

    public static ConcurrentLongLongMapBuilder newBuilder() {
        return new ConcurrentLongLongMapBuilder();
    }

    public ConcurrentLongLongMapBuilder withBuckets(int buckets) {
        this.buckets = buckets;
        return this;
    }

    public ConcurrentLongLongMapBuilder withInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        return this;
    }

    public ConcurrentLongLongMapBuilder withLoadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
        return this;
    }

    public ConcurrentLongLongMapBuilder withMode(MapMode mapMode) {
        this.mapMode = mapMode;
        return this;
    }

    public ConcurrentLongLongMapBuilder withDefaultValue(long defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public LongLongMap build() {
        return this.mapMode.createMap(this);
    }

    public static enum MapMode {
        BUSY_WAITING{

            @Override
            LongLongMap createMap(ConcurrentLongLongMapBuilder builder) {
                return new ConcurrentBusyWaitingLongLongMap(builder.buckets, builder.initialCapacity, builder.loadFactor, builder.defaultValue);
            }
        }
        ,
        BLOCKING{

            @Override
            LongLongMap createMap(ConcurrentLongLongMapBuilder builder) {
                return new ConcurrentLongLongMap(builder.buckets, builder.initialCapacity, builder.loadFactor, builder.defaultValue);
            }
        };


        abstract LongLongMap createMap(ConcurrentLongLongMapBuilder var1);
    }
}

