/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.fastutilconcurrentwrapper.map;

import com.trivago.fastutilconcurrentwrapper.IntIntMap;
import com.trivago.fastutilconcurrentwrapper.map.PrimitiveConcurrentMap;
import com.trivago.fastutilconcurrentwrapper.wrapper.PrimitiveFastutilIntIntWrapper;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;

public class ConcurrentBusyWaitingIntIntMap
extends PrimitiveConcurrentMap
implements IntIntMap {
    private final IntIntMap[] maps;
    private final int defaultValue;

    public ConcurrentBusyWaitingIntIntMap(int numBuckets, int initialCapacity, float loadFactor, int defaultValue) {
        super(numBuckets);
        this.maps = new IntIntMap[numBuckets];
        this.defaultValue = defaultValue;
        for (int i = 0; i < numBuckets; ++i) {
            this.maps[i] = new PrimitiveFastutilIntIntWrapper(initialCapacity, loadFactor, defaultValue);
        }
    }

    @Override
    public int size() {
        return super.size(this.maps);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty(this.maps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(int key) {
        int bucket = this.getBucket(key);
        Lock readLock = this.locks[bucket].readLock();
        while (!readLock.tryLock()) {
        }
        try {
            boolean bl = this.maps[bucket].containsKey(key);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get(int key) {
        int bucket = this.getBucket(key);
        Lock readLock = this.locks[bucket].readLock();
        while (!readLock.tryLock()) {
        }
        try {
            int n = this.maps[bucket].get(key);
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int put(int key, int value) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            int n = this.maps[bucket].put(key, value);
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public int getDefaultValue() {
        return this.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(int key) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            int n = this.maps[bucket].remove(key);
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(int key, int value) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            boolean bl = this.maps[bucket].remove(key, value);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int computeIfAbsent(int key, Int2IntFunction mappingFunction) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            int n = this.maps[bucket].computeIfAbsent(key, mappingFunction);
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int computeIfPresent(int key, BiFunction<Integer, Integer, Integer> mappingFunction) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            int n = this.maps[bucket].computeIfPresent(key, mappingFunction);
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }
}

