/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.fastutilconcurrentwrapper.map;

import com.trivago.fastutilconcurrentwrapper.LongIntMap;
import com.trivago.fastutilconcurrentwrapper.map.PrimitiveConcurrentMap;
import com.trivago.fastutilconcurrentwrapper.wrapper.PrimitiveFastutilLongIntWrapper;
import it.unimi.dsi.fastutil.longs.Long2IntFunction;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;

public class ConcurrentBusyWaitingLongIntMap
extends PrimitiveConcurrentMap
implements LongIntMap {
    private final LongIntMap[] maps;
    private final int defaultValue;

    public ConcurrentBusyWaitingLongIntMap(int numBuckets, int initialCapacity, float loadFactor, int defaultValue) {
        super(numBuckets);
        this.maps = new LongIntMap[numBuckets];
        this.defaultValue = defaultValue;
        for (int i = 0; i < numBuckets; ++i) {
            this.maps[i] = new PrimitiveFastutilLongIntWrapper(initialCapacity, loadFactor, defaultValue);
        }
    }

    @Override
    public int size() {
        return super.size(this.maps);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty(this.maps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(long key) {
        int bucket = this.getBucket(key);
        Lock readLock = this.locks[bucket].readLock();
        while (!readLock.tryLock()) {
        }
        try {
            boolean bl = this.maps[bucket].containsKey(key);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int get(long key) {
        int bucket = this.getBucket(key);
        Lock readLock = this.locks[bucket].readLock();
        while (!readLock.tryLock()) {
        }
        try {
            int n = this.maps[bucket].get(key);
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int put(long key, int value) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            int n = this.maps[bucket].put(key, value);
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public int getDefaultValue() {
        return this.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remove(long key) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            int n = this.maps[bucket].remove(key);
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(long key, int value) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            boolean bl = this.maps[bucket].remove(key, value);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int computeIfAbsent(long key, Long2IntFunction mappingFunction) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            int n = this.maps[bucket].computeIfAbsent(key, mappingFunction);
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int computeIfPresent(long key, BiFunction<Long, Integer, Integer> mappingFunction) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            int n = this.maps[bucket].computeIfPresent(key, mappingFunction);
            return n;
        }
        finally {
            writeLock.unlock();
        }
    }
}

