/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.fastutilconcurrentwrapper.map;

import com.trivago.fastutilconcurrentwrapper.LongFloatMap;
import com.trivago.fastutilconcurrentwrapper.map.PrimitiveConcurrentMap;
import com.trivago.fastutilconcurrentwrapper.wrapper.PrimitiveFastutilLongFloatWrapper;
import it.unimi.dsi.fastutil.longs.Long2FloatFunction;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;

public class ConcurrentLongFloatMap
extends PrimitiveConcurrentMap
implements LongFloatMap {
    private final LongFloatMap[] maps;
    private final float defaultValue;

    public ConcurrentLongFloatMap(int numBuckets, int initialCapacity, float loadFactor, float defaultValue) {
        super(numBuckets);
        this.maps = new LongFloatMap[numBuckets];
        this.defaultValue = defaultValue;
        for (int i = 0; i < numBuckets; ++i) {
            this.maps[i] = new PrimitiveFastutilLongFloatWrapper(initialCapacity, loadFactor, defaultValue);
        }
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int size() {
        return super.size(this.maps);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty(this.maps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(long key) {
        int bucket = this.getBucket(key);
        Lock readLock = this.locks[bucket].readLock();
        readLock.lock();
        try {
            boolean bl = this.maps[bucket].containsKey(key);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float get(long l) {
        float result;
        int bucket = this.getBucket(l);
        Lock readLock = this.locks[bucket].readLock();
        readLock.lock();
        try {
            result = this.maps[bucket].get(l);
        }
        finally {
            readLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float put(long key, float value) {
        float result;
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        writeLock.lock();
        try {
            result = this.maps[bucket].put(key, value);
        }
        finally {
            writeLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float remove(long key) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        writeLock.lock();
        try {
            float f = this.maps[bucket].remove(key);
            return f;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(long key, float value) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        writeLock.lock();
        try {
            boolean bl = this.maps[bucket].remove(key, value);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float computeIfAbsent(long key, Long2FloatFunction mappingFunction) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        writeLock.lock();
        try {
            float f = this.maps[bucket].computeIfAbsent(key, mappingFunction);
            return f;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float computeIfPresent(int key, BiFunction<Long, Float, Float> mappingFunction) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        writeLock.lock();
        try {
            float f = this.maps[bucket].computeIfPresent(key, mappingFunction);
            return f;
        }
        finally {
            writeLock.unlock();
        }
    }
}

