/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.fastutilconcurrentwrapper.map;

import com.trivago.fastutilconcurrentwrapper.LongLongMap;
import com.trivago.fastutilconcurrentwrapper.map.PrimitiveConcurrentMap;
import com.trivago.fastutilconcurrentwrapper.wrapper.PrimitiveFastutilLongLongWrapper;
import it.unimi.dsi.fastutil.longs.Long2LongFunction;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;

public class ConcurrentLongLongMap
extends PrimitiveConcurrentMap
implements LongLongMap {
    private final LongLongMap[] maps;
    private final long defaultValue;

    public ConcurrentLongLongMap(int numBuckets, int initialCapacity, float loadFactor, long defaultValue) {
        super(numBuckets);
        this.maps = new LongLongMap[numBuckets];
        this.defaultValue = defaultValue;
        for (int i = 0; i < numBuckets; ++i) {
            this.maps[i] = new PrimitiveFastutilLongLongWrapper(initialCapacity, loadFactor, defaultValue);
        }
    }

    @Override
    public int size() {
        return super.size(this.maps);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty(this.maps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(long key) {
        int bucket = this.getBucket(key);
        Lock readLock = this.locks[bucket].readLock();
        readLock.lock();
        try {
            boolean bl = this.maps[bucket].containsKey(key);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long get(long l) {
        long result;
        int bucket = this.getBucket(l);
        Lock readLock = this.locks[bucket].readLock();
        readLock.lock();
        try {
            result = this.maps[bucket].get(l);
        }
        finally {
            readLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long put(long key, long value) {
        long result;
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        writeLock.lock();
        try {
            result = this.maps[bucket].put(key, value);
        }
        finally {
            writeLock.unlock();
        }
        return result;
    }

    @Override
    public long getDefaultValue() {
        return this.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long remove(long key) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        writeLock.lock();
        try {
            long l = this.maps[bucket].remove(key);
            return l;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(long key, long value) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        writeLock.lock();
        try {
            boolean bl = this.maps[bucket].remove(key, value);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long computeIfAbsent(long key, Long2LongFunction mappingFunction) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        writeLock.lock();
        try {
            long l = this.maps[bucket].computeIfAbsent(key, mappingFunction);
            return l;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long computeIfPresent(long key, BiFunction<Long, Long, Long> mappingFunction) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        writeLock.lock();
        try {
            long l = this.maps[bucket].computeIfPresent(key, mappingFunction);
            return l;
        }
        finally {
            writeLock.unlock();
        }
    }
}

