/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.fastutilconcurrentwrapper.map;

import com.trivago.fastutilconcurrentwrapper.PrimitiveKeyMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class PrimitiveConcurrentMap {
    protected final int numBuckets;
    protected final ReadWriteLock[] locks;

    protected PrimitiveConcurrentMap(int numBuckets) {
        this.numBuckets = numBuckets;
        this.locks = new ReadWriteLock[numBuckets];
        for (int i = 0; i < numBuckets; ++i) {
            this.locks[i] = new ReentrantReadWriteLock();
        }
    }

    protected int size(PrimitiveKeyMap[] maps) {
        int sum = 0;
        for (int i = 0; i < this.numBuckets; ++i) {
            sum += this.sizeOfMap(i, maps);
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sizeOfMap(int index, PrimitiveKeyMap[] maps) {
        Lock readLock = this.locks[index].readLock();
        readLock.lock();
        try {
            int n = maps[index].size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    protected boolean isEmpty(PrimitiveKeyMap[] maps) {
        for (int i = 0; i < this.numBuckets; ++i) {
            if (this.isMapEmpty(i, maps)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMapEmpty(int index, PrimitiveKeyMap[] maps) {
        Lock readLock = this.locks[index].readLock();
        readLock.lock();
        try {
            boolean bl = maps[index].isEmpty();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    protected int getBucket(long key) {
        int hash = Long.hashCode(key);
        return this.getBucketCheckMinValue(hash);
    }

    protected int getBucket(int key) {
        int hash = Integer.hashCode(key);
        return this.getBucketCheckMinValue(hash);
    }

    private int getBucketCheckMinValue(int hash) {
        return Math.abs(hash == Integer.MIN_VALUE ? 0 : hash) % this.numBuckets;
    }
}

