/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.json.processors;

import com.trivago.cluecumber.engine.json.pojo.Element;
import com.trivago.cluecumber.engine.json.pojo.Report;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ElementIndexPreProcessor {
    @Inject
    public ElementIndexPreProcessor() {
    }

    public void addScenarioIndices(List<Report> reports) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Report report : reports) {
            elements.addAll(report.getElements());
        }
        List sortedElements = elements.stream().sorted(Comparator.comparing(Element::getStartTimestamp)).collect(Collectors.toList());
        int scenarioIndex = 0;
        for (Element element : sortedElements) {
            if (!element.isScenario()) continue;
            element.setScenarioIndex(++scenarioIndex);
        }
    }
}

