/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.pojos;

import com.trivago.cluecumber.engine.rendering.pages.renderering.RenderingUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class Times {
    private final List<IndexTime> times = new ArrayList<IndexTime>();

    public void addTime(long nanoseconds, int index) {
        this.times.add(new IndexTime(nanoseconds, index));
    }

    private IndexTime getMinimumTime() {
        Optional<IndexTime> time = this.times.stream().min(Comparator.comparingLong(t -> t.time));
        return time.orElseGet(() -> new IndexTime(0L, -1));
    }

    private IndexTime getMaximumTime() {
        Optional<IndexTime> time = this.times.stream().max(Comparator.comparingLong(t -> t.time));
        return time.orElseGet(() -> new IndexTime(0L, -1));
    }

    public String getMinimumTimeString() {
        return RenderingUtils.convertNanosecondsToTimeString(this.getMinimumTime().time);
    }

    public int getMinimumTimeIndex() {
        return this.getMinimumTime().index;
    }

    public String getMaximumTimeString() {
        return RenderingUtils.convertNanosecondsToTimeString(this.getMaximumTime().time);
    }

    public int getMaximumTimeIndex() {
        return this.getMaximumTime().index;
    }

    public String getAverageTimeString() {
        return RenderingUtils.convertNanosecondsToTimeString((long)this.times.stream().mapToLong(v -> v.time).average().orElse(0.0));
    }

    static class IndexTime {
        private final long time;
        private final int index;

        IndexTime(long time, int index) {
            this.time = time;
            this.index = index;
        }
    }
}

