/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.renderering;

import com.trivago.cluecumber.engine.constants.ChartConfiguration;
import com.trivago.cluecumber.engine.constants.Settings;
import com.trivago.cluecumber.engine.constants.Status;
import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.engine.rendering.pages.charts.StackedBarChartBuilder;
import com.trivago.cluecumber.engine.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.engine.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.engine.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllFeaturesPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.renderering.PageWithChartRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AllFeaturesPageRenderer
extends PageWithChartRenderer {
    private final ChartConfiguration chartConfiguration;
    private final PropertyManager propertyManager;

    @Inject
    public AllFeaturesPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.chartConfiguration = chartConfiguration;
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(AllFeaturesPageCollection allFeaturesPageCollection, Template template) throws CluecumberException {
        this.addChartJsonToReportDetails(allFeaturesPageCollection);
        if (this.propertyManager.getCustomParametersDisplayMode() == Settings.CustomParamDisplayMode.ALL_PAGES) {
            this.addCustomParametersToReportDetails(allFeaturesPageCollection, this.propertyManager.getCustomParameters());
        }
        return this.processedContent(template, allFeaturesPageCollection, this.propertyManager.getNavigationLinks());
    }

    private void addChartJsonToReportDetails(AllFeaturesPageCollection allFeaturesPageCollection) {
        ArrayList<Float> passed = new ArrayList<Float>();
        ArrayList<Float> failed = new ArrayList<Float>();
        ArrayList<Float> skipped = new ArrayList<Float>();
        int maximumNumberOfRuns = 0;
        for (Map.Entry<Feature, ResultCount> entry : allFeaturesPageCollection.getFeatureResultCounts().entrySet()) {
            ResultCount featureResultCount = entry.getValue();
            passed.add(Float.valueOf(featureResultCount.getPassed()));
            failed.add(Float.valueOf(featureResultCount.getFailed()));
            skipped.add(Float.valueOf(featureResultCount.getSkipped()));
            if (featureResultCount.getTotal() <= maximumNumberOfRuns) continue;
            maximumNumberOfRuns = featureResultCount.getTotal();
        }
        List<String> keys = allFeaturesPageCollection.getFeatureResultCounts().keySet().stream().map(Feature::getName).collect(Collectors.toList());
        Chart chart = new StackedBarChartBuilder(this.chartConfiguration).setLabels(keys).setxAxisLabel(allFeaturesPageCollection.getTotalNumberOfFeatures() + " Features").setyAxisLabel("Number of Scenarios").setyAxisStepSize(maximumNumberOfRuns).addValues(passed, Status.PASSED).addValues(failed, Status.FAILED).addValues(skipped, Status.SKIPPED).build();
        allFeaturesPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }
}

