/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.renderering;

import com.trivago.cluecumber.engine.constants.ChartConfiguration;
import com.trivago.cluecumber.engine.constants.Status;
import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.json.pojo.Element;
import com.trivago.cluecumber.engine.json.pojo.Report;
import com.trivago.cluecumber.engine.json.pojo.Step;
import com.trivago.cluecumber.engine.json.pojo.Tag;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.engine.rendering.pages.charts.PieChartBuilder;
import com.trivago.cluecumber.engine.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.renderering.PageWithChartRenderer;
import freemarker.template.Template;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AllScenariosPageRenderer
extends PageWithChartRenderer {
    private final PropertyManager propertyManager;
    private final ChartConfiguration chartConfiguration;

    @Inject
    AllScenariosPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.chartConfiguration = chartConfiguration;
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(AllScenariosPageCollection allScenariosPageCollection, Template template) throws CluecumberException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone, this.propertyManager.getNavigationLinks());
    }

    public String getRenderedContentByTagFilter(AllScenariosPageCollection allScenariosPageCollection, Template template, Tag tag) throws CluecumberException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        allScenariosPageCollectionClone.setTagFilter(tag);
        allScenariosPageCollectionClone.getReports().forEach(report -> {
            List<Element> elements = report.getElements().stream().filter(element -> element.getTags().contains(tag)).collect(Collectors.toList());
            report.setElements(elements);
        });
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone, this.propertyManager.getNavigationLinks());
    }

    public String getRenderedContentByStepFilter(AllScenariosPageCollection allScenariosPageCollection, Template template, Step step) throws CluecumberException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        allScenariosPageCollectionClone.setStepFilter(step);
        allScenariosPageCollectionClone.getReports().forEach(report -> {
            List<Element> elements = report.getElements().stream().filter(element -> element.getSteps().contains(step)).collect(Collectors.toList());
            report.setElements(elements);
        });
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone, this.propertyManager.getNavigationLinks());
    }

    public String getRenderedContentByFeatureFilter(AllScenariosPageCollection allScenariosPageCollection, Template template, Feature feature) throws CluecumberException {
        AllScenariosPageCollection allScenariosPageCollectionClone = this.getAllScenariosPageCollectionClone(allScenariosPageCollection);
        allScenariosPageCollectionClone.setFeatureFilter(feature);
        Report[] reportArray = (Report[])allScenariosPageCollectionClone.getReports().stream().filter(report -> report.getFeatureIndex() == feature.getIndex()).toArray(Report[]::new);
        allScenariosPageCollectionClone.clearReports();
        allScenariosPageCollectionClone.addReports(reportArray);
        this.addChartJsonToReportDetails(allScenariosPageCollectionClone);
        return this.processedContent(template, allScenariosPageCollectionClone, this.propertyManager.getNavigationLinks());
    }

    private void addChartJsonToReportDetails(AllScenariosPageCollection allScenariosPageCollection) {
        allScenariosPageCollection.getReportDetails().setChartJson(this.convertChartToJson(new PieChartBuilder(this.chartConfiguration).addValue(allScenariosPageCollection.getTotalNumberOfPassedScenarios(), Status.PASSED).addValue(allScenariosPageCollection.getTotalNumberOfFailedScenarios(), Status.FAILED).addValue(allScenariosPageCollection.getTotalNumberOfSkippedScenarios(), Status.SKIPPED).build()));
    }

    private AllScenariosPageCollection getAllScenariosPageCollectionClone(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberException {
        AllScenariosPageCollection clone;
        try {
            clone = allScenariosPageCollection.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CluecumberException("Clone of AllScenariosPageCollection not supported: " + e.getMessage());
        }
        this.addCustomParametersToReportDetails(clone, this.propertyManager.getCustomParameters());
        return clone;
    }
}

